
CREATE TABLE film (
    film_id smallint(5) NOT NULL AUTO_INCREMENT, 
    title varchar(255) NOT NULL, description text, 
    release_year year, 
    language_id tinyint(3) unsigned NOT NULL,
    original_language_id tinyint(3) unsigned, 
    rental_duration tinyint(3) unsigned DEFAULT 3 NOT NULL, 
    rental_rate decimal(4,2) DEFAULT 4.99 NOT NULL, length smallint(5) unsigned, replacement_cost decimal(5,2) DEFAULT 19.99 NOT NULL, rating enum('G','PG','PG-13','R','NC-17') DEFAULT 'G', special_features set('Trailers','Commentaries','Deleted Scenes','Behind the Scenes'),
last_update timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (film_id),
CONSTRAINT fk_film_language FOREIGN KEY (language_id) REFERENCES `language` (`language_id`) ON UPDATE CASCADE,
CONSTRAINT fk_film_language_original FOREIGN KEY (original_language_id) REFERENCES `language` (`language_id`) ON UPDATE CASCADE,
INDEX idx_title (title),
INDEX idx_fk_language_id (language_id),
INDEX idx_fk_original_language_id (original_language_id))
ENGINE=InnoDB DEFAULT CHARSET=utf8;

insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (1,'ACADEMY DINOSAUR','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies',2006,6,0.99,86,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (2,'ACE GOLDFINGER','A Astounding Epistle of a Database Administrator And a Explorer who must Find a Car in Ancient China',2006,3,4.99,48,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (3,'ADAPTATION HOLES','A Astounding Reflection of a Lumberjack And a Car who must Sink a Lumberjack in A Baloon Factory',2006,7,2.99,50,18.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (4,'AFFAIR PREJUDICE','A Fanciful Documentary of a Frisbee And a Lumberjack who must Chase a Monkey in A Shark Tank',2006,5,2.99,117,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (5,'AFRICAN EGG','A Fast-Paced Documentary of a Pastry Chef And a Dentist who must Pursue a Forensic Psychologist in The Gulf of Mexico',2006,6,2.99,130,22.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (6,'AGENT TRUMAN','A Intrepid Panorama of a Robot And a Boy who must Escape a Sumo Wrestler in Ancient China',2006,3,2.99,169,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (7,'AIRPLANE SIERRA','A Touching Saga of a Hunter And a Butler who must Discover a Butler in A Jet Boat',2006,6,4.99,62,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (8,'AIRPORT POLLOCK','A Epic Tale of a Moose And a Girl who must Confront a Monkey in Ancient India',2006,6,4.99,54,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (9,'ALABAMA DEVIL','A Thoughtful Panorama of a Database Administrator And a Mad Scientist who must Outgun a Mad Scientist in A Jet Boat',2006,3,2.99,114,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (10,'ALADDIN CALENDAR','A Action-Packed Tale of a Man And a Lumberjack who must Reach a Feminist in Ancient China',2006,6,4.99,63,24.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (11,'ALAMO VIDEOTAPE','A Boring Epistle of a Butler And a Cat who must Fight a Pastry Chef in A MySQL Convention',2006,6,0.99,126,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (12,'ALASKA PHANTOM','A Fanciful Saga of a Hunter And a Pastry Chef who must Vanquish a Boy in Australia',2006,6,0.99,136,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (13,'ALI FOREVER','A Action-Packed Drama of a Dentist And a Crocodile who must Battle a Feminist in The Canadian Rockies',2006,4,4.99,150,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (14,'ALICE FANTASIA','A Emotional Drama of a A Shark And a Database Administrator who must Vanquish a Pioneer in Soviet Georgia',2006,6,0.99,94,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (15,'ALIEN CENTER','A Brilliant Drama of a Cat And a Mad Scientist who must Battle a Feminist in A MySQL Convention',2006,5,2.99,46,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (16,'ALLEY EVOLUTION','A Fast-Paced Drama of a Robot And a Composer who must Battle a Astronaut in New Orleans',2006,6,2.99,180,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (17,'ALONE TRIP','A Fast-Paced Character Study of a Composer And a Dog who must Outgun a Boat in An Abandoned Fun House',2006,3,0.99,82,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (18,'ALTER VICTORY','A Thoughtful Drama of a Composer And a Feminist who must Meet a Secret Agent in The Canadian Rockies',2006,6,0.99,57,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (19,'AMADEUS HOLY','A Emotional Display of a Pioneer And a Technical Writer who must Battle a Man in A Baloon',2006,6,0.99,113,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (20,'AMELIE HELLFIGHTERS','A Boring Drama of a Woman And a Squirrel who must Conquer a Student in A Baloon',2006,4,4.99,79,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (21,'AMERICAN CIRCUS','A Insightful Drama of a Girl And a Astronaut who must Face a Database Administrator in A Shark Tank',2006,3,4.99,129,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (22,'AMISTAD MIDSUMMER','A Emotional Character Study of a Dentist And a Crocodile who must Meet a Sumo Wrestler in California',2006,6,2.99,85,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (23,'ANACONDA CONFESSIONS','A Lacklusture Display of a Dentist And a Dentist who must Fight a Girl in Australia',2006,3,0.99,92,9.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (24,'ANALYZE HOOSIERS','A Thoughtful Display of a Explorer And a Pastry Chef who must Overcome a Feminist in The Sahara Desert',2006,6,2.99,181,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (25,'ANGELS LIFE','A Thoughtful Display of a Woman And a Astronaut who must Battle a Robot in Berlin',2006,3,2.99,74,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (26,'ANNIE IDENTITY','A Amazing Panorama of a Pastry Chef And a Boat who must Escape a Woman in An Abandoned Amusement Park',2006,3,0.99,86,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (27,'ANONYMOUS HUMAN','A Amazing Reflection of a Database Administrator And a Astronaut who must Outrace a Database Administrator in A Shark Tank',2006,7,0.99,179,12.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (28,'ANTHEM LUKE','A Touching Panorama of a Waitress And a Woman who must Outrace a Dog in An Abandoned Amusement Park',2006,5,4.99,91,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (29,'ANTITRUST TOMATOES','A Fateful Yarn of a Womanizer And a Feminist who must Succumb a Database Administrator in Ancient India',2006,5,2.99,168,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (30,'ANYTHING SAVANNAH','A Epic Story of a Pastry Chef And a Woman who must Chase a Feminist in An Abandoned Fun House',2006,4,2.99,82,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (31,'APACHE DIVINE','A Awe-Inspiring Reflection of a Pastry Chef And a Teacher who must Overcome a Sumo Wrestler in A U-Boat',2006,5,4.99,92,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (32,'APOCALYPSE FLAMINGOS','A Astounding Story of a Dog And a Squirrel who must Defeat a Woman in An Abandoned Amusement Park',2006,6,4.99,119,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (33,'APOLLO TEEN','A Action-Packed Reflection of a Crocodile And a Explorer who must Find a Sumo Wrestler in An Abandoned Mine Shaft',2006,5,2.99,153,15.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (34,'ARABIA DOGMA','A Touching Epistle of a Madman And a Mad Cow who must Defeat a Student in Nigeria',2006,6,0.99,62,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (35,'ARACHNOPHOBIA ROLLERCOASTER','A Action-Packed Reflection of a Pastry Chef And a Composer who must Discover a Mad Scientist in The First Manned Space Station',2006,4,2.99,147,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (36,'ARGONAUTS TOWN','A Emotional Epistle of a Forensic Psychologist And a Butler who must Challenge a Waitress in An Abandoned Mine Shaft',2006,7,0.99,127,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (37,'ARIZONA BANG','A Brilliant Panorama of a Mad Scientist And a Mad Cow who must Meet a Pioneer in A Monastery',2006,3,2.99,121,28.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (38,'ARK RIDGEMONT','A Beautiful Yarn of a Pioneer And a Monkey who must Pursue a Explorer in The Sahara Desert',2006,6,0.99,68,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (39,'ARMAGEDDON LOST','A Fast-Paced Tale of a Boat And a Teacher who must Succumb a Composer in An Abandoned Mine Shaft',2006,5,0.99,99,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (40,'ARMY FLINTSTONES','A Boring Saga of a Database Administrator And a Womanizer who must Battle a Waitress in Nigeria',2006,4,0.99,148,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (41,'ARSENIC INDEPENDENCE','A Fanciful Documentary of a Mad Cow And a Womanizer who must Find a Dentist in Berlin',2006,4,0.99,137,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (42,'ARTIST COLDBLOODED','A Stunning Reflection of a Robot And a Moose who must Challenge a Woman in California',2006,5,2.99,170,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (43,'ATLANTIS CAUSE','A Thrilling Yarn of a Feminist And a Hunter who must Fight a Technical Writer in A Shark Tank',2006,6,2.99,170,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (44,'ATTACKS HATE','A Fast-Paced Panorama of a Technical Writer And a Mad Scientist who must Find a Feminist in An Abandoned Mine Shaft',2006,5,4.99,113,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (45,'ATTRACTION NEWTON','A Astounding Panorama of a Composer And a Frisbee who must Reach a Husband in Ancient Japan',2006,5,4.99,83,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (46,'AUTUMN CROW','A Beautiful Tale of a Dentist And a Mad Cow who must Battle a Moose in The Sahara Desert',2006,3,4.99,108,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (47,'BABY HALL','A Boring Character Study of a A Shark And a Girl who must Outrace a Feminist in An Abandoned Mine Shaft',2006,5,4.99,153,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (48,'BACKLASH UNDEFEATED','A Stunning Character Study of a Mad Scientist And a Mad Cow who must Kill a Car in A Monastery',2006,3,4.99,118,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (49,'BADMAN DAWN','A Emotional Panorama of a Pioneer And a Composer who must Escape a Mad Scientist in A Jet Boat',2006,6,2.99,162,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (50,'BAKED CLEOPATRA','A Stunning Drama of a Forensic Psychologist And a Husband who must Overcome a Waitress in A Monastery',2006,3,2.99,182,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (51,'BALLOON HOMEWARD','A Insightful Panorama of a Forensic Psychologist And a Mad Cow who must Build a Mad Scientist in The First Manned Space Station',2006,5,2.99,75,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (52,'BALLROOM MOCKINGBIRD','A Thrilling Documentary of a Composer And a Monkey who must Find a Feminist in California',2006,6,0.99,173,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (53,'BANG KWAI','A Epic Drama of a Madman And a Cat who must Face a A Shark in An Abandoned Amusement Park',2006,5,2.99,87,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (54,'BANGER PINOCCHIO','A Awe-Inspiring Drama of a Car And a Pastry Chef who must Chase a Crocodile in The First Manned Space Station',2006,5,0.99,113,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (55,'BARBARELLA STREETCAR','A Awe-Inspiring Story of a Feminist And a Cat who must Conquer a Dog in A Monastery',2006,6,2.99,65,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (56,'BAREFOOT MANCHURIAN','A Intrepid Story of a Cat And a Student who must Vanquish a Girl in An Abandoned Amusement Park',2006,6,2.99,129,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (57,'BASIC EASY','A Stunning Epistle of a Man And a Husband who must Reach a Mad Scientist in A Jet Boat',2006,4,2.99,90,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (58,'BEACH HEARTBREAKERS','A Fateful Display of a Womanizer And a Mad Scientist who must Outgun a A Shark in Soviet Georgia',2006,6,2.99,122,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (59,'BEAR GRACELAND','A Astounding Saga of a Dog And a Boy who must Kill a Teacher in The First Manned Space Station',2006,4,2.99,160,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (60,'BEAST HUNCHBACK','A Awe-Inspiring Epistle of a Student And a Squirrel who must Defeat a Boy in Ancient China',2006,3,4.99,89,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (61,'BEAUTY GREASE','A Fast-Paced Display of a Composer And a Moose who must Sink a Robot in An Abandoned Mine Shaft',2006,5,4.99,175,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (62,'BED HIGHBALL','A Astounding Panorama of a Lumberjack And a Dog who must Redeem a Woman in An Abandoned Fun House',2006,5,2.99,106,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (63,'BEDAZZLED MARRIED','A Astounding Character Study of a Madman And a Robot who must Meet a Mad Scientist in An Abandoned Fun House',2006,6,0.99,73,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (64,'BEETHOVEN EXORCIST','A Epic Display of a Pioneer And a Student who must Challenge a Butler in The Gulf of Mexico',2006,6,0.99,151,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (65,'BEHAVIOR RUNAWAY','A Unbelieveable Drama of a Student And a Husband who must Outrace a Sumo Wrestler in Berlin',2006,3,4.99,100,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (66,'BENEATH RUSH','A Astounding Panorama of a Man And a Monkey who must Discover a Man in The First Manned Space Station',2006,6,0.99,53,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (67,'BERETS AGENT','A Taut Saga of a Crocodile And a Boy who must Overcome a Technical Writer in Ancient China',2006,5,2.99,77,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (68,'BETRAYED REAR','A Emotional Character Study of a Boat And a Pioneer who must Find a Explorer in A Shark Tank',2006,5,4.99,122,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (69,'BEVERLY OUTLAW','A Fanciful Documentary of a Womanizer And a Boat who must Defeat a Madman in The First Manned Space Station',2006,3,2.99,85,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (70,'BIKINI BORROWERS','A Astounding Drama of a Astronaut And a Cat who must Discover a Woman in The First Manned Space Station',2006,7,4.99,142,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (71,'BILKO ANONYMOUS','A Emotional Reflection of a Teacher And a Man who must Meet a Cat in The First Manned Space Station',2006,3,4.99,100,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (72,'BILL OTHERS','A Stunning Saga of a Mad Scientist And a Forensic Psychologist who must Challenge a Squirrel in A MySQL Convention',2006,6,2.99,93,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (73,'BINGO TALENTED','A Touching Tale of a Girl And a Crocodile who must Discover a Waitress in Nigeria',2006,5,2.99,150,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (74,'BIRCH ANTITRUST','A Fanciful Panorama of a Husband And a Pioneer who must Outgun a Dog in A Baloon',2006,4,4.99,162,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (75,'BIRD INDEPENDENCE','A Thrilling Documentary of a Car And a Student who must Sink a Hunter in The Canadian Rockies',2006,6,4.99,163,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (76,'BIRDCAGE CASPER','A Fast-Paced Saga of a Frisbee And a Astronaut who must Overcome a Feminist in Ancient India',2006,4,0.99,103,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (77,'BIRDS PERDITION','A Boring Story of a Womanizer And a Pioneer who must Face a Dog in California',2006,5,4.99,61,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (78,'BLACKOUT PRIVATE','A Intrepid Yarn of a Pastry Chef And a Mad Scientist who must Challenge a Secret Agent in Ancient Japan',2006,7,2.99,85,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (79,'BLADE POLISH','A Thoughtful Character Study of a Frisbee And a Pastry Chef who must Fight a Dentist in The First Manned Space Station',2006,5,0.99,114,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (80,'BLANKET BEVERLY','A Emotional Documentary of a Student And a Girl who must Build a Boat in Nigeria',2006,7,2.99,148,21.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (81,'BLINDNESS GUN','A Touching Drama of a Robot And a Dentist who must Meet a Hunter in A Jet Boat',2006,6,4.99,103,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (82,'BLOOD ARGONAUTS','A Boring Drama of a Explorer And a Man who must Kill a Lumberjack in A Manhattan Penthouse',2006,3,0.99,71,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (83,'BLUES INSTINCT','A Insightful Documentary of a Boat And a Composer who must Meet a Forensic Psychologist in An Abandoned Fun House',2006,5,2.99,50,18.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (84,'BOILED DARES','A Awe-Inspiring Story of a Waitress And a Dog who must Discover a Dentist in Ancient Japan',2006,7,4.99,102,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (85,'BONNIE HOLOCAUST','A Fast-Paced Story of a Crocodile And a Robot who must Find a Moose in Ancient Japan',2006,4,0.99,63,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (86,'BOOGIE AMELIE','A Lacklusture Character Study of a Husband And a Sumo Wrestler who must Succumb a Technical Writer in The Gulf of Mexico',2006,6,4.99,121,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (87,'BOONDOCK BALLROOM','A Fateful Panorama of a Crocodile And a Boy who must Defeat a Monkey in The Gulf of Mexico',2006,7,0.99,76,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (88,'BORN SPINAL','A Touching Epistle of a Frisbee And a Husband who must Pursue a Student in Nigeria',2006,7,4.99,179,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (89,'BORROWERS BEDAZZLED','A Brilliant Epistle of a Teacher And a Sumo Wrestler who must Defeat a Man in An Abandoned Fun House',2006,7,0.99,63,22.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (90,'BOULEVARD MOB','A Fateful Epistle of a Moose And a Monkey who must Confront a Lumberjack in Ancient China',2006,3,0.99,63,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (91,'BOUND CHEAPER','A Thrilling Panorama of a Database Administrator And a Astronaut who must Challenge a Lumberjack in A Baloon',2006,5,0.99,98,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (92,'BOWFINGER GABLES','A Fast-Paced Yarn of a Waitress And a Composer who must Outgun a Dentist in California',2006,7,4.99,72,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (93,'BRANNIGAN SUNRISE','A Amazing Epistle of a Moose And a Crocodile who must Outrace a Dog in Berlin',2006,4,4.99,121,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (94,'BRAVEHEART HUMAN','A Insightful Story of a Dog And a Pastry Chef who must Battle a Girl in Berlin',2006,7,2.99,176,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (95,'BREAKFAST GOLDFINGER','A Beautiful Reflection of a Student And a Student who must Fight a Moose in Berlin',2006,5,4.99,123,18.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (96,'BREAKING HOME','A Beautiful Display of a Secret Agent And a Monkey who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,4,2.99,169,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (97,'BRIDE INTRIGUE','A Epic Tale of a Robot And a Monkey who must Vanquish a Man in New Orleans',2006,7,0.99,56,24.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (98,'BRIGHT ENCOUNTERS','A Fateful Yarn of a Lumberjack And a Feminist who must Conquer a Student in A Jet Boat',2006,4,4.99,73,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (99,'BRINGING HYSTERICAL','A Fateful Saga of a A Shark And a Technical Writer who must Find a Woman in A Jet Boat',2006,7,2.99,136,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (100,'BROOKLYN DESERT','A Beautiful Drama of a Dentist And a Composer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,7,4.99,161,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (101,'BROTHERHOOD BLANKET','A Fateful Character Study of a Butler And a Technical Writer who must Sink a Astronaut in Ancient Japan',2006,3,0.99,73,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (102,'BUBBLE GROSSE','A Awe-Inspiring Panorama of a Crocodile And a Moose who must Confront a Girl in A Baloon',2006,4,4.99,60,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (103,'BUCKET BROTHERHOOD','A Amazing Display of a Girl And a Womanizer who must Succumb a Lumberjack in A Baloon Factory',2006,7,4.99,133,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (104,'BUGSY SONG','A Awe-Inspiring Character Study of a Secret Agent And a Boat who must Find a Squirrel in The First Manned Space Station',2006,4,2.99,119,17.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (105,'BULL SHAWSHANK','A Fanciful Drama of a Moose And a Squirrel who must Conquer a Pioneer in The Canadian Rockies',2006,6,0.99,125,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (106,'BULWORTH COMMANDMENTS','A Amazing Display of a Mad Cow And a Pioneer who must Redeem a Sumo Wrestler in The Outback',2006,4,2.99,61,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (107,'BUNCH MINDS','A Emotional Story of a Feminist And a Feminist who must Escape a Pastry Chef in A MySQL Convention',2006,4,2.99,63,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (108,'BUTCH PANTHER','A Lacklusture Yarn of a Feminist And a Database Administrator who must Face a Hunter in New Orleans',2006,6,0.99,67,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (109,'BUTTERFLY CHOCOLAT','A Fateful Story of a Girl And a Composer who must Conquer a Husband in A Shark Tank',2006,3,0.99,89,17.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (110,'CABIN FLASH','A Stunning Epistle of a Boat And a Man who must Challenge a A Shark in A Baloon Factory',2006,4,0.99,53,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (111,'CADDYSHACK JEDI','A Awe-Inspiring Epistle of a Woman And a Madman who must Fight a Robot in Soviet Georgia',2006,3,0.99,52,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (112,'CALENDAR GUNFIGHT','A Thrilling Drama of a Frisbee And a Lumberjack who must Sink a Man in Nigeria',2006,4,4.99,120,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (113,'CALIFORNIA BIRDS','A Thrilling Yarn of a Database Administrator And a Robot who must Battle a Database Administrator in Ancient India',2006,4,4.99,75,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (114,'CAMELOT VACATION','A Touching Character Study of a Woman And a Waitress who must Battle a Pastry Chef in A MySQL Convention',2006,3,0.99,61,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (115,'CAMPUS REMEMBER','A Astounding Drama of a Crocodile And a Mad Cow who must Build a Robot in A Jet Boat',2006,5,2.99,167,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (116,'CANDIDATE PERDITION','A Brilliant Epistle of a Composer And a Database Administrator who must Vanquish a Mad Scientist in The First Manned Space Station',2006,4,2.99,70,10.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (117,'CANDLES GRAPES','A Fanciful Character Study of a Monkey And a Explorer who must Build a Astronaut in An Abandoned Fun House',2006,6,4.99,135,15.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (118,'CANYON STOCK','A Thoughtful Reflection of a Waitress And a Feminist who must Escape a Squirrel in A Manhattan Penthouse',2006,7,0.99,85,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (119,'CAPER MOTIONS','A Fateful Saga of a Moose And a Car who must Pursue a Woman in A MySQL Convention',2006,6,0.99,176,22.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (120,'CARIBBEAN LIBERTY','A Fanciful Tale of a Pioneer And a Technical Writer who must Outgun a Pioneer in A Shark Tank',2006,3,4.99,92,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (121,'CAROL TEXAS','A Astounding Character Study of a Composer And a Student who must Overcome a Composer in A Monastery',2006,4,2.99,151,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (122,'CARRIE BUNCH','A Amazing Epistle of a Student And a Astronaut who must Discover a Frisbee in The Canadian Rockies',2006,7,0.99,114,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (123,'CASABLANCA SUPER','A Amazing Panorama of a Crocodile And a Forensic Psychologist who must Pursue a Secret Agent in The First Manned Space Station',2006,6,4.99,85,22.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (124,'CASPER DRAGONFLY','A Intrepid Documentary of a Boat And a Crocodile who must Chase a Robot in The Sahara Desert',2006,3,4.99,163,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (125,'CASSIDY WYOMING','A Intrepid Drama of a Frisbee And a Hunter who must Kill a Secret Agent in New Orleans',2006,5,2.99,61,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (126,'CASUALTIES ENCINO','A Insightful Yarn of a A Shark And a Pastry Chef who must Face a Boy in A Monastery',2006,3,4.99,179,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (127,'CAT CONEHEADS','A Fast-Paced Panorama of a Girl And a A Shark who must Confront a Boy in Ancient India',2006,5,4.99,112,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (128,'CATCH AMISTAD','A Boring Reflection of a Lumberjack And a Feminist who must Discover a Woman in Nigeria',2006,7,0.99,183,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (129,'CAUSE DATE','A Taut Tale of a Explorer And a Pastry Chef who must Conquer a Hunter in A MySQL Convention',2006,3,2.99,179,16.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (130,'CELEBRITY HORN','A Amazing Documentary of a Secret Agent And a Astronaut who must Vanquish a Hunter in A Shark Tank',2006,7,0.99,110,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (131,'CENTER DINOSAUR','A Beautiful Character Study of a Sumo Wrestler And a Dentist who must Find a Dog in California',2006,5,4.99,152,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (132,'CHAINSAW UPTOWN','A Beautiful Documentary of a Boy And a Robot who must Discover a Squirrel in Australia',2006,6,0.99,114,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (133,'CHAMBER ITALIAN','A Fateful Reflection of a Moose And a Husband who must Overcome a Monkey in Nigeria',2006,7,4.99,117,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (134,'CHAMPION FLATLINERS','A Amazing Story of a Mad Cow And a Dog who must Kill a Husband in A Monastery',2006,4,4.99,51,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (135,'CHANCE RESURRECTION','A Astounding Story of a Forensic Psychologist And a Forensic Psychologist who must Overcome a Moose in Ancient China',2006,3,2.99,70,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (136,'CHAPLIN LICENSE','A Boring Drama of a Dog And a Forensic Psychologist who must Outrace a Explorer in Ancient India',2006,7,2.99,146,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (137,'CHARADE DUFFEL','A Action-Packed Display of a Man And a Waitress who must Build a Dog in A MySQL Convention',2006,3,2.99,66,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (138,'CHARIOTS CONSPIRACY','A Unbelieveable Epistle of a Robot And a Husband who must Chase a Robot in The First Manned Space Station',2006,5,2.99,71,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (139,'CHASING FIGHT','A Astounding Saga of a Technical Writer And a Butler who must Battle a Butler in A Shark Tank',2006,7,4.99,114,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (140,'CHEAPER CLYDE','A Emotional Character Study of a Pioneer And a Girl who must Discover a Dog in Ancient Japan',2006,6,0.99,87,23.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (141,'CHICAGO NORTH','A Fateful Yarn of a Mad Cow And a Waitress who must Battle a Student in California',2006,6,4.99,185,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (142,'CHICKEN HELLFIGHTERS','A Emotional Drama of a Dog And a Explorer who must Outrace a Technical Writer in Australia',2006,3,0.99,122,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (143,'CHILL LUCK','A Lacklusture Epistle of a Boat And a Technical Writer who must Fight a A Shark in The Canadian Rockies',2006,6,0.99,142,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (144,'CHINATOWN GLADIATOR','A Brilliant Panorama of a Technical Writer And a Lumberjack who must Escape a Butler in Ancient India',2006,7,4.99,61,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (145,'CHISUM BEHAVIOR','A Epic Documentary of a Sumo Wrestler And a Butler who must Kill a Car in Ancient India',2006,5,4.99,124,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (146,'CHITTY LOCK','A Boring Epistle of a Boat And a Database Administrator who must Kill a Sumo Wrestler in The First Manned Space Station',2006,6,2.99,107,24.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (147,'CHOCOLAT HARRY','A Action-Packed Epistle of a Dentist And a Moose who must Meet a Mad Cow in Ancient Japan',2006,5,0.99,101,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (148,'CHOCOLATE DUCK','A Unbelieveable Story of a Mad Scientist And a Technical Writer who must Discover a Composer in Ancient China',2006,3,2.99,132,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (149,'CHRISTMAS MOONSHINE','A Action-Packed Epistle of a Feminist And a Astronaut who must Conquer a Boat in A Manhattan Penthouse',2006,7,0.99,150,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (150,'CIDER DESIRE','A Stunning Character Study of a Composer And a Mad Cow who must Succumb a Cat in Soviet Georgia',2006,7,2.99,101,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (151,'CINCINATTI WHISPERER','A Brilliant Saga of a Pastry Chef And a Hunter who must Confront a Butler in Berlin',2006,5,4.99,143,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (152,'CIRCUS YOUTH','A Thoughtful Drama of a Pastry Chef And a Dentist who must Pursue a Girl in A Baloon',2006,5,2.99,90,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (153,'CITIZEN SHREK','A Fanciful Character Study of a Technical Writer And a Husband who must Redeem a Robot in The Outback',2006,7,0.99,165,18.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (154,'CLASH FREDDY','A Amazing Yarn of a Composer And a Squirrel who must Escape a Astronaut in Australia',2006,6,2.99,81,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (155,'CLEOPATRA DEVIL','A Fanciful Documentary of a Crocodile And a Technical Writer who must Fight a A Shark in A Baloon',2006,6,0.99,150,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (156,'CLERKS ANGELS','A Thrilling Display of a Sumo Wrestler And a Girl who must Confront a Man in A Baloon',2006,3,4.99,164,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (157,'CLOCKWORK PARADISE','A Insightful Documentary of a Technical Writer And a Feminist who must Challenge a Cat in A Baloon',2006,7,0.99,143,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (158,'CLONES PINOCCHIO','A Amazing Drama of a Car And a Robot who must Pursue a Dentist in New Orleans',2006,6,2.99,124,16.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (159,'CLOSER BANG','A Unbelieveable Panorama of a Frisbee And a Hunter who must Vanquish a Monkey in Ancient India',2006,5,4.99,58,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (160,'CLUB GRAFFITI','A Epic Tale of a Pioneer And a Hunter who must Escape a Girl in A U-Boat',2006,4,0.99,65,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (161,'CLUE GRAIL','A Taut Tale of a Butler And a Mad Scientist who must Build a Crocodile in Ancient China',2006,6,4.99,70,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (162,'CLUELESS BUCKET','A Taut Tale of a Car And a Pioneer who must Conquer a Sumo Wrestler in An Abandoned Fun House',2006,4,2.99,95,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (163,'CLYDE THEORY','A Beautiful Yarn of a Astronaut And a Frisbee who must Overcome a Explorer in A Jet Boat',2006,4,0.99,139,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (164,'COAST RAINBOW','A Astounding Documentary of a Mad Cow And a Pioneer who must Challenge a Butler in The Sahara Desert',2006,4,0.99,55,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (165,'COLDBLOODED DARLING','A Brilliant Panorama of a Dentist And a Moose who must Find a Student in The Gulf of Mexico',2006,7,4.99,70,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (166,'COLOR PHILADELPHIA','A Thoughtful Panorama of a Car And a Crocodile who must Sink a Monkey in The Sahara Desert',2006,6,2.99,149,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (167,'COMA HEAD','A Awe-Inspiring Drama of a Boy And a Frisbee who must Escape a Pastry Chef in California',2006,6,4.99,109,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (168,'COMANCHEROS ENEMY','A Boring Saga of a Lumberjack And a Monkey who must Find a Monkey in The Gulf of Mexico',2006,5,0.99,67,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (169,'COMFORTS RUSH','A Unbelieveable Panorama of a Pioneer And a Husband who must Meet a Mad Cow in An Abandoned Mine Shaft',2006,3,2.99,76,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (170,'COMMAND DARLING','A Awe-Inspiring Tale of a Forensic Psychologist And a Woman who must Challenge a Database Administrator in Ancient Japan',2006,5,4.99,120,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (171,'COMMANDMENTS EXPRESS','A Fanciful Saga of a Student And a Mad Scientist who must Battle a Hunter in An Abandoned Mine Shaft',2006,6,4.99,59,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (172,'CONEHEADS SMOOCHY','A Touching Story of a Womanizer And a Composer who must Pursue a Husband in Nigeria',2006,7,4.99,112,12.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (173,'CONFESSIONS MAGUIRE','A Insightful Story of a Car And a Boy who must Battle a Technical Writer in A Baloon',2006,7,4.99,65,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (174,'CONFIDENTIAL INTERVIEW','A Stunning Reflection of a Cat And a Woman who must Find a Astronaut in Ancient Japan',2006,6,4.99,180,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (175,'CONFUSED CANDLES','A Stunning Epistle of a Cat And a Forensic Psychologist who must Confront a Pioneer in A Baloon',2006,3,2.99,122,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (176,'CONGENIALITY QUEST','A Touching Documentary of a Cat And a Pastry Chef who must Find a Lumberjack in A Baloon',2006,6,0.99,87,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (177,'CONNECTICUT TRAMP','A Unbelieveable Drama of a Crocodile And a Mad Cow who must Reach a Dentist in A Shark Tank',2006,4,4.99,172,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (178,'CONNECTION MICROCOSMOS','A Fateful Documentary of a Crocodile And a Husband who must Face a Husband in The First Manned Space Station',2006,6,0.99,115,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (179,'CONQUERER NUTS','A Taut Drama of a Mad Scientist And a Man who must Escape a Pioneer in An Abandoned Mine Shaft',2006,4,4.99,173,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (180,'CONSPIRACY SPIRIT','A Awe-Inspiring Story of a Student And a Frisbee who must Conquer a Crocodile in An Abandoned Mine Shaft',2006,4,2.99,184,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (181,'CONTACT ANONYMOUS','A Insightful Display of a A Shark And a Monkey who must Face a Database Administrator in Ancient India',2006,7,2.99,166,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (182,'CONTROL ANTHEM','A Fateful Documentary of a Robot And a Student who must Battle a Cat in A Monastery',2006,7,4.99,185,9.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (183,'CONVERSATION DOWNHILL','A Taut Character Study of a Husband And a Waitress who must Sink a Squirrel in A MySQL Convention',2006,4,4.99,112,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (184,'CORE SUIT','A Unbelieveable Tale of a Car And a Explorer who must Confront a Boat in A Manhattan Penthouse',2006,3,2.99,92,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (185,'COWBOY DOOM','A Astounding Drama of a Boy And a Lumberjack who must Fight a Butler in A Baloon',2006,3,2.99,146,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (186,'CRAFT OUTFIELD','A Lacklusture Display of a Explorer And a Hunter who must Succumb a Database Administrator in A Baloon Factory',2006,6,0.99,64,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (187,'CRANES RESERVOIR','A Fanciful Documentary of a Teacher And a Dog who must Outgun a Forensic Psychologist in A Baloon Factory',2006,5,2.99,57,12.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (188,'CRAZY HOME','A Fanciful Panorama of a Boy And a Woman who must Vanquish a Database Administrator in The Outback',2006,7,2.99,136,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (189,'CREATURES SHAKESPEARE','A Emotional Drama of a Womanizer And a Squirrel who must Vanquish a Crocodile in Ancient India',2006,3,0.99,139,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (190,'CREEPERS KANE','A Awe-Inspiring Reflection of a Squirrel And a Boat who must Outrace a Car in A Jet Boat',2006,5,4.99,172,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (191,'CROOKED FROGMEN','A Unbelieveable Drama of a Hunter And a Database Administrator who must Battle a Crocodile in An Abandoned Amusement Park',2006,6,0.99,143,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (192,'CROSSING DIVORCE','A Beautiful Documentary of a Dog And a Robot who must Redeem a Womanizer in Berlin',2006,4,4.99,50,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (193,'CROSSROADS CASUALTIES','A Intrepid Documentary of a Sumo Wrestler And a Astronaut who must Battle a Composer in The Outback',2006,5,2.99,153,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (194,'CROW GREASE','A Awe-Inspiring Documentary of a Woman And a Husband who must Sink a Database Administrator in The First Manned Space Station',2006,6,0.99,104,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (195,'CROWDS TELEMARK','A Intrepid Documentary of a Astronaut And a Forensic Psychologist who must Find a Frisbee in An Abandoned Fun House',2006,3,4.99,112,16.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (196,'CRUELTY UNFORGIVEN','A Brilliant Tale of a Car And a Moose who must Battle a Dentist in Nigeria',2006,7,0.99,69,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (197,'CRUSADE HONEY','A Fast-Paced Reflection of a Explorer And a Butler who must Battle a Madman in An Abandoned Amusement Park',2006,4,2.99,112,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (198,'CRYSTAL BREAKING','A Fast-Paced Character Study of a Feminist And a Explorer who must Face a Pastry Chef in Ancient Japan',2006,6,2.99,184,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (199,'CUPBOARD SINNERS','A Emotional Reflection of a Frisbee And a Boat who must Reach a Pastry Chef in An Abandoned Amusement Park',2006,4,2.99,56,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (200,'CURTAIN VIDEOTAPE','A Boring Reflection of a Dentist And a Mad Cow who must Chase a Secret Agent in A Shark Tank',2006,7,0.99,133,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (201,'CYCLONE FAMILY','A Lacklusture Drama of a Student And a Monkey who must Sink a Womanizer in A MySQL Convention',2006,7,2.99,176,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (202,'DADDY PITTSBURGH','A Epic Story of a A Shark And a Student who must Confront a Explorer in The Gulf of Mexico',2006,5,4.99,161,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (203,'DAISY MENAGERIE','A Fast-Paced Saga of a Pastry Chef And a Monkey who must Sink a Composer in Ancient India',2006,5,4.99,84,9.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (204,'DALMATIONS SWEDEN','A Emotional Epistle of a Moose And a Hunter who must Overcome a Robot in A Manhattan Penthouse',2006,4,0.99,106,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (205,'DANCES NONE','A Insightful Reflection of a A Shark And a Dog who must Kill a Butler in An Abandoned Amusement Park',2006,3,0.99,58,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (206,'DANCING FEVER','A Stunning Story of a Explorer And a Forensic Psychologist who must Face a Crocodile in A Shark Tank',2006,6,0.99,144,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (207,'DANGEROUS UPTOWN','A Unbelieveable Story of a Mad Scientist And a Woman who must Overcome a Dog in California',2006,7,4.99,121,26.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (208,'DARES PLUTO','A Fateful Story of a Robot And a Dentist who must Defeat a Astronaut in New Orleans',2006,7,2.99,89,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (209,'DARKNESS WAR','A Touching Documentary of a Husband And a Hunter who must Escape a Boy in The Sahara Desert',2006,6,2.99,99,24.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (210,'DARKO DORADO','A Stunning Reflection of a Frisbee And a Husband who must Redeem a Dog in New Orleans',2006,3,4.99,130,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (211,'DARLING BREAKING','A Brilliant Documentary of a Astronaut And a Squirrel who must Succumb a Student in The Gulf of Mexico',2006,7,4.99,165,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (212,'DARN FORRESTER','A Fateful Story of a A Shark And a Explorer who must Succumb a Technical Writer in A Jet Boat',2006,7,4.99,185,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (213,'DATE SPEED','A Touching Saga of a Composer And a Moose who must Discover a Dentist in A MySQL Convention',2006,4,0.99,104,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (214,'DAUGHTER MADIGAN','A Beautiful Tale of a Hunter And a Mad Scientist who must Confront a Squirrel in The First Manned Space Station',2006,3,4.99,59,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (215,'DAWN POND','A Thoughtful Documentary of a Dentist And a Forensic Psychologist who must Defeat a Waitress in Berlin',2006,4,4.99,57,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (216,'DAY UNFAITHFUL','A Stunning Documentary of a Composer And a Mad Scientist who must Find a Technical Writer in A U-Boat',2006,3,4.99,113,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (217,'DAZED PUNK','A Action-Packed Story of a Pioneer And a Technical Writer who must Discover a Forensic Psychologist in An Abandoned Amusement Park',2006,6,4.99,120,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (218,'DECEIVER BETRAYED','A Taut Story of a Moose And a Squirrel who must Build a Husband in Ancient India',2006,7,0.99,122,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (219,'DEEP CRUSADE','A Amazing Tale of a Crocodile And a Squirrel who must Discover a Composer in Australia',2006,6,4.99,51,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (220,'DEER VIRGINIAN','A Thoughtful Story of a Mad Cow And a Womanizer who must Overcome a Mad Scientist in Soviet Georgia',2006,7,2.99,106,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (221,'DELIVERANCE MULHOLLAND','A Astounding Saga of a Monkey And a Moose who must Conquer a Butler in A Shark Tank',2006,4,0.99,100,9.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (222,'DESERT POSEIDON','A Brilliant Documentary of a Butler And a Frisbee who must Build a Astronaut in New Orleans',2006,4,4.99,64,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (223,'DESIRE ALIEN','A Fast-Paced Tale of a Dog And a Forensic Psychologist who must Meet a Astronaut in The First Manned Space Station',2006,7,2.99,76,24.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (224,'DESPERATE TRAINSPOTTING','A Epic Yarn of a Forensic Psychologist And a Teacher who must Face a Lumberjack in California',2006,7,4.99,81,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (225,'DESTINATION JERK','A Beautiful Yarn of a Teacher And a Cat who must Build a Car in A U-Boat',2006,3,0.99,76,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (226,'DESTINY SATURDAY','A Touching Drama of a Crocodile And a Crocodile who must Conquer a Explorer in Soviet Georgia',2006,4,4.99,56,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (227,'DETAILS PACKER','A Epic Saga of a Waitress And a Composer who must Face a Boat in A U-Boat',2006,4,4.99,88,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (228,'DETECTIVE VISION','A Fanciful Documentary of a Pioneer And a Woman who must Redeem a Hunter in Ancient Japan',2006,4,0.99,143,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (229,'DEVIL DESIRE','A Beautiful Reflection of a Monkey And a Dentist who must Face a Database Administrator in Ancient Japan',2006,6,4.99,87,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (230,'DIARY PANIC','A Thoughtful Character Study of a Frisbee And a Mad Cow who must Outgun a Man in Ancient India',2006,7,2.99,107,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (231,'DINOSAUR SECRETARY','A Action-Packed Drama of a Feminist And a Girl who must Reach a Robot in The Canadian Rockies',2006,7,2.99,63,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (232,'DIRTY ACE','A Action-Packed Character Study of a Forensic Psychologist And a Girl who must Build a Dentist in The Outback',2006,7,2.99,147,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (233,'DISCIPLE MOTHER','A Touching Reflection of a Mad Scientist And a Boat who must Face a Moose in A Shark Tank',2006,3,0.99,141,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (234,'DISTURBING SCARFACE','A Lacklusture Display of a Crocodile And a Butler who must Overcome a Monkey in A U-Boat',2006,6,2.99,94,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (235,'DIVIDE MONSTER','A Intrepid Saga of a Man And a Forensic Psychologist who must Reach a Squirrel in A Monastery',2006,6,2.99,68,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (236,'DIVINE RESURRECTION','A Boring Character Study of a Man And a Womanizer who must Succumb a Teacher in An Abandoned Amusement Park',2006,4,2.99,100,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (237,'DIVORCE SHINING','A Unbelieveable Saga of a Crocodile And a Student who must Discover a Cat in Ancient India',2006,3,2.99,47,21.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (238,'DOCTOR GRAIL','A Insightful Drama of a Womanizer And a Waitress who must Reach a Forensic Psychologist in The Outback',2006,4,2.99,57,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (239,'DOGMA FAMILY','A Brilliant Character Study of a Database Administrator And a Monkey who must Succumb a Astronaut in New Orleans',2006,5,4.99,122,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (240,'DOLLS RAGE','A Thrilling Display of a Pioneer And a Frisbee who must Escape a Teacher in The Outback',2006,7,2.99,120,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (241,'DONNIE ALLEY','A Awe-Inspiring Tale of a Butler And a Frisbee who must Vanquish a Teacher in Ancient Japan',2006,4,0.99,125,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (242,'DOOM DANCING','A Astounding Panorama of a Car And a Mad Scientist who must Battle a Lumberjack in A MySQL Convention',2006,4,0.99,68,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (243,'DOORS PRESIDENT','A Awe-Inspiring Display of a Squirrel And a Woman who must Overcome a Boy in The Gulf of Mexico',2006,3,4.99,49,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (244,'DORADO NOTTING','A Action-Packed Tale of a Sumo Wrestler And a A Shark who must Meet a Frisbee in California',2006,5,4.99,139,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (245,'DOUBLE WRATH','A Thoughtful Yarn of a Womanizer And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,4,0.99,177,28.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (246,'DOUBTFIRE LABYRINTH','A Intrepid Panorama of a Butler And a Composer who must Meet a Mad Cow in The Sahara Desert',2006,5,4.99,154,16.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (247,'DOWNHILL ENOUGH','A Emotional Tale of a Pastry Chef And a Forensic Psychologist who must Succumb a Monkey in The Sahara Desert',2006,3,0.99,47,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (248,'DOZEN LION','A Taut Drama of a Cat And a Girl who must Defeat a Frisbee in The Canadian Rockies',2006,6,4.99,177,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (249,'DRACULA CRYSTAL','A Thrilling Reflection of a Feminist And a Cat who must Find a Frisbee in An Abandoned Fun House',2006,7,0.99,176,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (250,'DRAGON SQUAD','A Taut Reflection of a Boy And a Waitress who must Outgun a Teacher in Ancient China',2006,4,0.99,170,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (251,'DRAGONFLY STRANGERS','A Boring Documentary of a Pioneer And a Man who must Vanquish a Man in Nigeria',2006,6,4.99,133,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (252,'DREAM PICKUP','A Epic Display of a Car And a Composer who must Overcome a Forensic Psychologist in The Gulf of Mexico',2006,6,2.99,135,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (253,'DRIFTER COMMANDMENTS','A Epic Reflection of a Womanizer And a Squirrel who must Discover a Husband in A Jet Boat',2006,5,4.99,61,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (254,'DRIVER ANNIE','A Lacklusture Character Study of a Butler And a Car who must Redeem a Boat in An Abandoned Fun House',2006,4,2.99,159,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (255,'DRIVING POLISH','A Action-Packed Yarn of a Feminist And a Technical Writer who must Sink a Boat in An Abandoned Mine Shaft',2006,6,4.99,175,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (256,'DROP WATERFRONT','A Fanciful Documentary of a Husband And a Explorer who must Reach a Madman in Ancient China',2006,6,4.99,178,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (257,'DRUMLINE CYCLONE','A Insightful Panorama of a Monkey And a Sumo Wrestler who must Outrace a Mad Scientist in The Canadian Rockies',2006,3,0.99,110,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (258,'DRUMS DYNAMITE','A Epic Display of a Crocodile And a Crocodile who must Confront a Dog in An Abandoned Amusement Park',2006,6,0.99,96,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (259,'DUCK RACER','A Lacklusture Yarn of a Teacher And a Squirrel who must Overcome a Dog in A Shark Tank',2006,4,2.99,116,15.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (260,'DUDE BLINDNESS','A Stunning Reflection of a Husband And a Lumberjack who must Face a Frisbee in An Abandoned Fun House',2006,3,4.99,132,9.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (261,'DUFFEL APOCALYPSE','A Emotional Display of a Boat And a Explorer who must Challenge a Madman in A MySQL Convention',2006,5,0.99,171,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (262,'DUMBO LUST','A Touching Display of a Feminist And a Dentist who must Conquer a Husband in The Gulf of Mexico',2006,5,0.99,119,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (263,'DURHAM PANKY','A Brilliant Panorama of a Girl And a Boy who must Face a Mad Scientist in An Abandoned Mine Shaft',2006,6,4.99,154,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (264,'DWARFS ALTER','A Emotional Yarn of a Girl And a Dog who must Challenge a Composer in Ancient Japan',2006,6,2.99,101,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (265,'DYING MAKER','A Intrepid Tale of a Boat And a Monkey who must Kill a Cat in California',2006,5,4.99,168,28.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (266,'DYNAMITE TARZAN','A Intrepid Documentary of a Forensic Psychologist And a Mad Scientist who must Face a Explorer in A U-Boat',2006,4,0.99,141,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (267,'EAGLES PANKY','A Thoughtful Story of a Car And a Boy who must Find a A Shark in The Sahara Desert',2006,4,4.99,140,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (268,'EARLY HOME','A Amazing Panorama of a Mad Scientist And a Husband who must Meet a Woman in The Outback',2006,6,4.99,96,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (269,'EARRING INSTINCT','A Stunning Character Study of a Dentist And a Mad Cow who must Find a Teacher in Nigeria',2006,3,0.99,98,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (270,'EARTH VISION','A Stunning Drama of a Butler And a Madman who must Outrace a Womanizer in Ancient India',2006,7,0.99,85,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (271,'EASY GLADIATOR','A Fateful Story of a Monkey And a Girl who must Overcome a Pastry Chef in Ancient India',2006,5,4.99,148,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (272,'EDGE KISSING','A Beautiful Yarn of a Composer And a Mad Cow who must Redeem a Mad Scientist in A Jet Boat',2006,5,4.99,153,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (273,'EFFECT GLADIATOR','A Beautiful Display of a Pastry Chef And a Pastry Chef who must Outgun a Forensic Psychologist in A Manhattan Penthouse',2006,6,0.99,107,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (274,'EGG IGBY','A Beautiful Documentary of a Boat And a Sumo Wrestler who must Succumb a Database Administrator in The First Manned Space Station',2006,4,2.99,67,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (275,'EGYPT TENENBAUMS','A Intrepid Story of a Madman And a Secret Agent who must Outrace a Astronaut in An Abandoned Amusement Park',2006,3,0.99,85,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (276,'ELEMENT FREDDY','A Awe-Inspiring Reflection of a Waitress And a Squirrel who must Kill a Mad Cow in A Jet Boat',2006,6,4.99,115,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (277,'ELEPHANT TROJAN','A Beautiful Panorama of a Lumberjack And a Forensic Psychologist who must Overcome a Frisbee in A Baloon',2006,4,4.99,126,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (278,'ELF MURDER','A Action-Packed Story of a Frisbee And a Woman who must Reach a Girl in An Abandoned Mine Shaft',2006,4,4.99,155,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (279,'ELIZABETH SHANE','A Lacklusture Display of a Womanizer And a Dog who must Face a Sumo Wrestler in Ancient Japan',2006,7,4.99,152,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (280,'EMPIRE MALKOVICH','A Amazing Story of a Feminist And a Cat who must Face a Car in An Abandoned Fun House',2006,7,0.99,177,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (281,'ENCINO ELF','A Astounding Drama of a Feminist And a Teacher who must Confront a Husband in A Baloon',2006,6,0.99,143,9.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (282,'ENCOUNTERS CURTAIN','A Insightful Epistle of a Pastry Chef And a Womanizer who must Build a Boat in New Orleans',2006,5,0.99,92,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (283,'ENDING CROWDS','A Unbelieveable Display of a Dentist And a Madman who must Vanquish a Squirrel in Berlin',2006,6,0.99,85,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (284,'ENEMY ODDS','A Fanciful Panorama of a Mad Scientist And a Woman who must Pursue a Astronaut in Ancient India',2006,5,4.99,77,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (285,'ENGLISH BULWORTH','A Intrepid Epistle of a Pastry Chef And a Pastry Chef who must Pursue a Crocodile in Ancient China',2006,3,0.99,51,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (286,'ENOUGH RAGING','A Astounding Character Study of a Boat And a Secret Agent who must Find a Mad Cow in The Sahara Desert',2006,7,2.99,158,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (287,'ENTRAPMENT SATISFACTION','A Thoughtful Panorama of a Hunter And a Teacher who must Reach a Mad Cow in A U-Boat',2006,5,0.99,176,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (288,'ESCAPE METROPOLIS','A Taut Yarn of a Astronaut And a Technical Writer who must Outgun a Boat in New Orleans',2006,7,2.99,167,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (289,'EVE RESURRECTION','A Awe-Inspiring Yarn of a Pastry Chef And a Database Administrator who must Challenge a Teacher in A Baloon',2006,5,4.99,66,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (290,'EVERYONE CRAFT','A Fateful Display of a Waitress And a Dentist who must Reach a Butler in Nigeria',2006,4,0.99,163,29.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (291,'EVOLUTION ALTER','A Fanciful Character Study of a Feminist And a Madman who must Find a Explorer in A Baloon Factory',2006,5,0.99,174,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (292,'EXCITEMENT EVE','A Brilliant Documentary of a Monkey And a Car who must Conquer a Crocodile in A Shark Tank',2006,3,0.99,51,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (293,'EXORCIST STING','A Touching Drama of a Dog And a Sumo Wrestler who must Conquer a Mad Scientist in Berlin',2006,6,2.99,167,17.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (294,'EXPECATIONS NATURAL','A Amazing Drama of a Butler And a Husband who must Reach a A Shark in A U-Boat',2006,5,4.99,138,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (295,'EXPENDABLE STALLION','A Amazing Character Study of a Mad Cow And a Squirrel who must Discover a Hunter in A U-Boat',2006,3,0.99,97,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (296,'EXPRESS LONELY','A Boring Drama of a Astronaut And a Boat who must Face a Boat in California',2006,5,2.99,178,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (297,'EXTRAORDINARY CONQUERER','A Stunning Story of a Dog And a Feminist who must Face a Forensic Psychologist in Berlin',2006,6,2.99,122,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (298,'EYES DRIVING','A Thrilling Story of a Cat And a Waitress who must Fight a Explorer in The Outback',2006,4,2.99,172,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (299,'FACTORY DRAGON','A Action-Packed Saga of a Teacher And a Frisbee who must Escape a Lumberjack in The Sahara Desert',2006,4,0.99,144,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (300,'FALCON VOLUME','A Fateful Saga of a Sumo Wrestler And a Hunter who must Redeem a A Shark in New Orleans',2006,5,4.99,102,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (301,'FAMILY SWEET','A Epic Documentary of a Teacher And a Boy who must Escape a Woman in Berlin',2006,4,0.99,155,24.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (302,'FANTASIA PARK','A Thoughtful Documentary of a Mad Scientist And a A Shark who must Outrace a Feminist in Australia',2006,5,2.99,131,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (303,'FANTASY TROOPERS','A Touching Saga of a Teacher And a Monkey who must Overcome a Secret Agent in A MySQL Convention',2006,6,0.99,58,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (304,'FARGO GANDHI','A Thrilling Reflection of a Pastry Chef And a Crocodile who must Reach a Teacher in The Outback',2006,3,2.99,130,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (305,'FATAL HAUNTED','A Beautiful Drama of a Student And a Secret Agent who must Confront a Dentist in Ancient Japan',2006,6,2.99,91,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (306,'FEATHERS METAL','A Thoughtful Yarn of a Monkey And a Teacher who must Find a Dog in Australia',2006,3,0.99,104,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (307,'FELLOWSHIP AUTUMN','A Lacklusture Reflection of a Dentist And a Hunter who must Meet a Teacher in A Baloon',2006,6,4.99,77,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (308,'FERRIS MOTHER','A Touching Display of a Frisbee And a Frisbee who must Kill a Girl in The Gulf of Mexico',2006,3,2.99,142,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (309,'FEUD FROGMEN','A Brilliant Reflection of a Database Administrator And a Mad Cow who must Chase a Woman in The Canadian Rockies',2006,6,0.99,98,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (310,'FEVER EMPIRE','A Insightful Panorama of a Cat And a Boat who must Defeat a Boat in The Gulf of Mexico',2006,5,4.99,158,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (311,'FICTION CHRISTMAS','A Emotional Yarn of a A Shark And a Student who must Battle a Robot in An Abandoned Mine Shaft',2006,4,0.99,72,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (312,'FIDDLER LOST','A Boring Tale of a Squirrel And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,4,4.99,75,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (313,'FIDELITY DEVIL','A Awe-Inspiring Drama of a Technical Writer And a Composer who must Reach a Pastry Chef in A U-Boat',2006,5,4.99,118,11.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (314,'FIGHT JAWBREAKER','A Intrepid Panorama of a Womanizer And a Girl who must Escape a Girl in A Manhattan Penthouse',2006,3,0.99,91,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (315,'FINDING ANACONDA','A Fateful Tale of a Database Administrator And a Girl who must Battle a Squirrel in New Orleans',2006,4,0.99,156,10.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (316,'FIRE WOLVES','A Intrepid Documentary of a Frisbee And a Dog who must Outrace a Lumberjack in Nigeria',2006,5,4.99,173,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (317,'FIREBALL PHILADELPHIA','A Amazing Yarn of a Dentist And a A Shark who must Vanquish a Madman in An Abandoned Mine Shaft',2006,4,0.99,148,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (318,'FIREHOUSE VIETNAM','A Awe-Inspiring Character Study of a Boat And a Boy who must Kill a Pastry Chef in The Sahara Desert',2006,7,0.99,103,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (319,'FISH OPUS','A Touching Display of a Feminist And a Girl who must Confront a Astronaut in Australia',2006,4,2.99,125,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (320,'FLAMINGOS CONNECTICUT','A Fast-Paced Reflection of a Composer And a Composer who must Meet a Cat in The Sahara Desert',2006,4,4.99,80,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (321,'FLASH WARS','A Astounding Saga of a Moose And a Pastry Chef who must Chase a Student in The Gulf of Mexico',2006,3,4.99,123,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (322,'FLATLINERS KILLER','A Taut Display of a Secret Agent And a Waitress who must Sink a Robot in An Abandoned Mine Shaft',2006,5,2.99,100,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (323,'FLIGHT LIES','A Stunning Character Study of a Crocodile And a Pioneer who must Pursue a Teacher in New Orleans',2006,7,4.99,179,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (324,'FLINTSTONES HAPPINESS','A Fateful Story of a Husband And a Moose who must Vanquish a Boy in California',2006,3,4.99,148,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (325,'FLOATS GARDEN','A Action-Packed Epistle of a Robot And a Car who must Chase a Boat in Ancient Japan',2006,6,2.99,145,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (326,'FLYING HOOK','A Thrilling Display of a Mad Cow And a Dog who must Challenge a Frisbee in Nigeria',2006,6,2.99,69,18.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (327,'FOOL MOCKINGBIRD','A Lacklusture Tale of a Crocodile And a Composer who must Defeat a Madman in A U-Boat',2006,3,4.99,158,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (328,'FOREVER CANDIDATE','A Unbelieveable Panorama of a Technical Writer And a Man who must Pursue a Frisbee in A U-Boat',2006,7,2.99,131,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (329,'FORREST SONS','A Thrilling Documentary of a Forensic Psychologist And a Butler who must Defeat a Explorer in A Jet Boat',2006,4,2.99,63,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (330,'FORRESTER COMANCHEROS','A Fateful Tale of a Squirrel And a Forensic Psychologist who must Redeem a Man in Nigeria',2006,7,4.99,112,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (331,'FORWARD TEMPLE','A Astounding Display of a Forensic Psychologist And a Mad Scientist who must Challenge a Girl in New Orleans',2006,6,2.99,90,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (332,'FRANKENSTEIN STRANGER','A Insightful Character Study of a Feminist And a Pioneer who must Pursue a Pastry Chef in Nigeria',2006,7,0.99,159,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (333,'FREAKY POCUS','A Fast-Paced Documentary of a Pastry Chef And a Crocodile who must Chase a Squirrel in The Gulf of Mexico',2006,7,2.99,126,16.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (334,'FREDDY STORM','A Intrepid Saga of a Man And a Lumberjack who must Vanquish a Husband in The Outback',2006,6,4.99,65,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (335,'FREEDOM CLEOPATRA','A Emotional Reflection of a Dentist And a Mad Cow who must Face a Squirrel in A Baloon',2006,5,0.99,133,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (336,'FRENCH HOLIDAY','A Thrilling Epistle of a Dog And a Feminist who must Kill a Madman in Berlin',2006,5,4.99,99,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (337,'FRIDA SLIPPER','A Fateful Story of a Lumberjack And a Car who must Escape a Boat in An Abandoned Mine Shaft',2006,6,2.99,73,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (338,'FRISCO FORREST','A Beautiful Documentary of a Woman And a Pioneer who must Pursue a Mad Scientist in A Shark Tank',2006,6,4.99,51,23.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (339,'FROGMEN BREAKING','A Unbelieveable Yarn of a Mad Scientist And a Cat who must Chase a Lumberjack in Australia',2006,5,0.99,111,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (340,'FRONTIER CABIN','A Emotional Story of a Madman And a Waitress who must Battle a Teacher in An Abandoned Fun House',2006,6,4.99,183,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (341,'FROST HEAD','A Amazing Reflection of a Lumberjack And a Cat who must Discover a Husband in A MySQL Convention',2006,5,0.99,82,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (342,'FUGITIVE MAGUIRE','A Taut Epistle of a Feminist And a Sumo Wrestler who must Battle a Crocodile in Australia',2006,7,4.99,83,28.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (343,'FULL FLATLINERS','A Beautiful Documentary of a Astronaut And a Moose who must Pursue a Monkey in A Shark Tank',2006,6,2.99,94,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (344,'FURY MURDER','A Lacklusture Reflection of a Boat And a Forensic Psychologist who must Fight a Waitress in A Monastery',2006,3,0.99,178,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (345,'GABLES METROPOLIS','A Fateful Display of a Cat And a Pioneer who must Challenge a Pastry Chef in A Baloon Factory',2006,3,0.99,161,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (346,'GALAXY SWEETHEARTS','A Emotional Reflection of a Womanizer And a Pioneer who must Face a Squirrel in Berlin',2006,4,4.99,128,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (347,'GAMES BOWFINGER','A Astounding Documentary of a Butler And a Explorer who must Challenge a Butler in A Monastery',2006,7,4.99,119,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (348,'GANDHI KWAI','A Thoughtful Display of a Mad Scientist And a Secret Agent who must Chase a Boat in Berlin',2006,7,0.99,86,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (349,'GANGS PRIDE','A Taut Character Study of a Woman And a A Shark who must Confront a Frisbee in Berlin',2006,4,2.99,185,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (350,'GARDEN ISLAND','A Unbelieveable Character Study of a Womanizer And a Madman who must Reach a Man in The Outback',2006,3,4.99,80,21.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (351,'GASLIGHT CRUSADE','A Amazing Epistle of a Boy And a Astronaut who must Redeem a Man in The Gulf of Mexico',2006,4,2.99,106,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (352,'GATHERING CALENDAR','A Intrepid Tale of a Pioneer And a Moose who must Conquer a Frisbee in A MySQL Convention',2006,4,0.99,176,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (353,'GENTLEMEN STAGE','A Awe-Inspiring Reflection of a Monkey And a Student who must Overcome a Dentist in The First Manned Space Station',2006,6,2.99,125,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (354,'GHOST GROUNDHOG','A Brilliant Panorama of a Madman And a Composer who must Succumb a Car in Ancient India',2006,6,4.99,85,18.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (355,'GHOSTBUSTERS ELF','A Thoughtful Epistle of a Dog And a Feminist who must Chase a Composer in Berlin',2006,7,0.99,101,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (356,'GIANT TROOPERS','A Fateful Display of a Feminist And a Monkey who must Vanquish a Monkey in The Canadian Rockies',2006,5,2.99,102,10.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (357,'GILBERT PELICAN','A Fateful Tale of a Man And a Feminist who must Conquer a Crocodile in A Manhattan Penthouse',2006,7,0.99,114,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (358,'GILMORE BOILED','A Unbelieveable Documentary of a Boat And a Husband who must Succumb a Student in A U-Boat',2006,5,0.99,163,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (359,'GLADIATOR WESTWARD','A Astounding Reflection of a Squirrel And a Sumo Wrestler who must Sink a Dentist in Ancient Japan',2006,6,4.99,173,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (360,'GLASS DYING','A Astounding Drama of a Frisbee And a Astronaut who must Fight a Dog in Ancient Japan',2006,4,0.99,103,24.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (361,'GLEAMING JAWBREAKER','A Amazing Display of a Composer And a Forensic Psychologist who must Discover a Car in The Canadian Rockies',2006,5,2.99,89,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (362,'GLORY TRACY','A Amazing Saga of a Woman And a Womanizer who must Discover a Cat in The First Manned Space Station',2006,7,2.99,115,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (363,'GO PURPLE','A Fast-Paced Display of a Car And a Database Administrator who must Battle a Woman in A Baloon',2006,3,0.99,54,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (364,'GODFATHER DIARY','A Stunning Saga of a Lumberjack And a Squirrel who must Chase a Car in The Outback',2006,3,2.99,73,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (365,'GOLD RIVER','A Taut Documentary of a Database Administrator And a Waitress who must Reach a Mad Scientist in A Baloon Factory',2006,4,4.99,154,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (366,'GOLDFINGER SENSIBILITY','A Insightful Drama of a Mad Scientist And a Hunter who must Defeat a Pastry Chef in New Orleans',2006,3,0.99,93,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (367,'GOLDMINE TYCOON','A Brilliant Epistle of a Composer And a Frisbee who must Conquer a Husband in The Outback',2006,6,0.99,153,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (368,'GONE TROUBLE','A Insightful Character Study of a Mad Cow And a Forensic Psychologist who must Conquer a A Shark in A Manhattan Penthouse',2006,7,2.99,84,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (369,'GOODFELLAS SALUTE','A Unbelieveable Tale of a Dog And a Explorer who must Sink a Mad Cow in A Baloon Factory',2006,4,4.99,56,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (370,'GORGEOUS BINGO','A Action-Packed Display of a Sumo Wrestler And a Car who must Overcome a Waitress in A Baloon Factory',2006,4,2.99,108,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (371,'GOSFORD DONNIE','A Epic Panorama of a Mad Scientist And a Monkey who must Redeem a Secret Agent in Berlin',2006,5,4.99,129,17.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (372,'GRACELAND DYNAMITE','A Taut Display of a Cat And a Girl who must Overcome a Database Administrator in New Orleans',2006,5,4.99,140,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (373,'GRADUATE LORD','A Lacklusture Epistle of a Girl And a A Shark who must Meet a Mad Scientist in Ancient China',2006,7,2.99,156,14.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (374,'GRAFFITI LOVE','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Build a Composer in Berlin',2006,3,0.99,117,29.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (375,'GRAIL FRANKENSTEIN','A Unbelieveable Saga of a Teacher And a Monkey who must Fight a Girl in An Abandoned Mine Shaft',2006,4,2.99,85,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (376,'GRAPES FURY','A Boring Yarn of a Mad Cow And a Sumo Wrestler who must Meet a Robot in Australia',2006,4,0.99,155,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (377,'GREASE YOUTH','A Emotional Panorama of a Secret Agent And a Waitress who must Escape a Composer in Soviet Georgia',2006,7,0.99,135,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (378,'GREATEST NORTH','A Astounding Character Study of a Secret Agent And a Robot who must Build a A Shark in Berlin',2006,5,2.99,93,24.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (379,'GREEDY ROOTS','A Amazing Reflection of a A Shark And a Butler who must Chase a Hunter in The Canadian Rockies',2006,7,0.99,166,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (380,'GREEK EVERYONE','A Stunning Display of a Butler And a Teacher who must Confront a A Shark in The First Manned Space Station',2006,7,2.99,176,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (381,'GRINCH MASSAGE','A Intrepid Display of a Madman And a Feminist who must Pursue a Pioneer in The First Manned Space Station',2006,7,4.99,150,25.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (382,'GRIT CLOCKWORK','A Thoughtful Display of a Dentist And a Squirrel who must Confront a Lumberjack in A Shark Tank',2006,3,0.99,137,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (383,'GROOVE FICTION','A Unbelieveable Reflection of a Moose And a A Shark who must Defeat a Lumberjack in An Abandoned Mine Shaft',2006,6,0.99,111,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (384,'GROSSE WONDERFUL','A Epic Drama of a Cat And a Explorer who must Redeem a Moose in Australia',2006,5,4.99,49,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (385,'GROUNDHOG UNCUT','A Brilliant Panorama of a Astronaut And a Technical Writer who must Discover a Butler in A Manhattan Penthouse',2006,6,4.99,139,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (386,'GUMP DATE','A Intrepid Yarn of a Explorer And a Student who must Kill a Husband in An Abandoned Mine Shaft',2006,3,4.99,53,12.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (387,'GUN BONNIE','A Boring Display of a Sumo Wrestler And a Husband who must Build a Waitress in The Gulf of Mexico',2006,7,0.99,100,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (388,'GUNFIGHT MOON','A Epic Reflection of a Pastry Chef And a Explorer who must Reach a Dentist in The Sahara Desert',2006,5,0.99,70,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (389,'GUNFIGHTER MUSSOLINI','A Touching Saga of a Robot And a Boy who must Kill a Man in Ancient Japan',2006,3,2.99,127,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (390,'GUYS FALCON','A Boring Story of a Woman And a Feminist who must Redeem a Squirrel in A U-Boat',2006,4,4.99,84,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (391,'HALF OUTFIELD','A Epic Epistle of a Database Administrator And a Crocodile who must Face a Madman in A Jet Boat',2006,6,2.99,146,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (392,'HALL CASSIDY','A Beautiful Panorama of a Pastry Chef And a A Shark who must Battle a Pioneer in Soviet Georgia',2006,5,4.99,51,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (393,'HALLOWEEN NUTS','A Amazing Panorama of a Forensic Psychologist And a Technical Writer who must Fight a Dentist in A U-Boat',2006,6,2.99,47,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (394,'HAMLET WISDOM','A Touching Reflection of a Man And a Man who must Sink a Robot in The Outback',2006,7,2.99,146,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (395,'HANDICAP BOONDOCK','A Beautiful Display of a Pioneer And a Squirrel who must Vanquish a Sumo Wrestler in Soviet Georgia',2006,4,0.99,108,28.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (396,'HANGING DEEP','A Action-Packed Yarn of a Boat And a Crocodile who must Build a Monkey in Berlin',2006,5,4.99,62,18.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (397,'HANKY OCTOBER','A Boring Epistle of a Database Administrator And a Explorer who must Pursue a Madman in Soviet Georgia',2006,5,2.99,107,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (398,'HANOVER GALAXY','A Stunning Reflection of a Girl And a Secret Agent who must Succumb a Boy in A MySQL Convention',2006,5,4.99,47,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (399,'HAPPINESS UNITED','A Action-Packed Panorama of a Husband And a Feminist who must Meet a Forensic Psychologist in Ancient Japan',2006,6,2.99,100,23.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (400,'HARDLY ROBBERS','A Emotional Character Study of a Hunter And a Car who must Kill a Woman in Berlin',2006,7,2.99,72,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (401,'HAROLD FRENCH','A Stunning Saga of a Sumo Wrestler And a Student who must Outrace a Moose in The Sahara Desert',2006,6,0.99,168,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (402,'HARPER DYING','A Awe-Inspiring Reflection of a Woman And a Cat who must Confront a Feminist in The Sahara Desert',2006,3,0.99,52,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (403,'HARRY IDAHO','A Taut Yarn of a Technical Writer And a Feminist who must Outrace a Dog in California',2006,5,4.99,121,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (404,'HATE HANDICAP','A Intrepid Reflection of a Mad Scientist And a Pioneer who must Overcome a Hunter in The First Manned Space Station',2006,4,0.99,107,26.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (405,'HAUNTED ANTITRUST','A Amazing Saga of a Man And a Dentist who must Reach a Technical Writer in Ancient India',2006,6,4.99,76,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (406,'HAUNTING PIANIST','A Fast-Paced Story of a Database Administrator And a Composer who must Defeat a Squirrel in An Abandoned Amusement Park',2006,5,0.99,181,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (407,'HAWK CHILL','A Action-Packed Drama of a Mad Scientist And a Composer who must Outgun a Car in Australia',2006,5,0.99,47,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (408,'HEAD STRANGER','A Thoughtful Saga of a Hunter And a Crocodile who must Confront a Dog in The Gulf of Mexico',2006,4,4.99,69,28.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (409,'HEARTBREAKERS BRIGHT','A Awe-Inspiring Documentary of a A Shark And a Dentist who must Outrace a Pastry Chef in The Canadian Rockies',2006,3,4.99,59,9.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (410,'HEAVEN FREEDOM','A Intrepid Story of a Butler And a Car who must Vanquish a Man in New Orleans',2006,7,2.99,48,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (411,'HEAVENLY GUN','A Beautiful Yarn of a Forensic Psychologist And a Frisbee who must Battle a Moose in A Jet Boat',2006,5,4.99,49,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (412,'HEAVYWEIGHTS BEAST','A Unbelieveable Story of a Composer And a Dog who must Overcome a Womanizer in An Abandoned Amusement Park',2006,6,4.99,102,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (413,'HEDWIG ALTER','A Action-Packed Yarn of a Womanizer And a Lumberjack who must Chase a Sumo Wrestler in A Monastery',2006,7,2.99,169,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (414,'HELLFIGHTERS SIERRA','A Taut Reflection of a A Shark And a Dentist who must Battle a Boat in Soviet Georgia',2006,3,2.99,75,23.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (415,'HIGH ENCINO','A Fateful Saga of a Waitress And a Hunter who must Outrace a Sumo Wrestler in Australia',2006,3,2.99,84,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (416,'HIGHBALL POTTER','A Action-Packed Saga of a Husband And a Dog who must Redeem a Database Administrator in The Sahara Desert',2006,6,0.99,110,10.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (417,'HILLS NEIGHBORS','A Epic Display of a Hunter And a Feminist who must Sink a Car in A U-Boat',2006,5,0.99,93,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (418,'HOBBIT ALIEN','A Emotional Drama of a Husband And a Girl who must Outgun a Composer in The First Manned Space Station',2006,5,0.99,157,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (419,'HOCUS FRIDA','A Awe-Inspiring Tale of a Girl And a Madman who must Outgun a Student in A Shark Tank',2006,4,2.99,141,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (420,'HOLES BRANNIGAN','A Fast-Paced Reflection of a Technical Writer And a Student who must Fight a Boy in The Canadian Rockies',2006,7,4.99,128,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (421,'HOLIDAY GAMES','A Insightful Reflection of a Waitress And a Madman who must Pursue a Boy in Ancient Japan',2006,7,4.99,78,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (422,'HOLLOW JEOPARDY','A Beautiful Character Study of a Robot And a Astronaut who must Overcome a Boat in A Monastery',2006,7,4.99,136,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (423,'HOLLYWOOD ANONYMOUS','A Fast-Paced Epistle of a Boy And a Explorer who must Escape a Dog in A U-Boat',2006,7,0.99,69,29.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (424,'HOLOCAUST HIGHBALL','A Awe-Inspiring Yarn of a Composer And a Man who must Find a Robot in Soviet Georgia',2006,6,0.99,149,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (425,'HOLY TADPOLE','A Action-Packed Display of a Feminist And a Pioneer who must Pursue a Dog in A Baloon Factory',2006,6,0.99,88,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (426,'HOME PITY','A Touching Panorama of a Man And a Secret Agent who must Challenge a Teacher in A MySQL Convention',2006,7,4.99,185,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (427,'HOMEWARD CIDER','A Taut Reflection of a Astronaut And a Squirrel who must Fight a Squirrel in A Manhattan Penthouse',2006,5,0.99,103,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (428,'HOMICIDE PEACH','A Astounding Documentary of a Hunter And a Boy who must Confront a Boy in A MySQL Convention',2006,6,2.99,141,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (429,'HONEY TIES','A Taut Story of a Waitress And a Crocodile who must Outrace a Lumberjack in A Shark Tank',2006,3,0.99,84,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (430,'HOOK CHARIOTS','A Insightful Story of a Boy And a Dog who must Redeem a Boy in Australia',2006,7,0.99,49,23.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (431,'HOOSIERS BIRDCAGE','A Astounding Display of a Explorer And a Boat who must Vanquish a Car in The First Manned Space Station',2006,3,2.99,176,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (432,'HOPE TOOTSIE','A Amazing Documentary of a Student And a Sumo Wrestler who must Outgun a A Shark in A Shark Tank',2006,4,2.99,139,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (433,'HORN WORKING','A Stunning Display of a Mad Scientist And a Technical Writer who must Succumb a Monkey in A Shark Tank',2006,4,2.99,95,23.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (434,'HORROR REIGN','A Touching Documentary of a A Shark And a Car who must Build a Husband in Nigeria',2006,3,0.99,139,25.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (435,'HOTEL HAPPINESS','A Thrilling Yarn of a Pastry Chef And a A Shark who must Challenge a Mad Scientist in The Outback',2006,6,4.99,181,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (436,'HOURS RAGE','A Fateful Story of a Explorer And a Feminist who must Meet a Technical Writer in Soviet Georgia',2006,4,0.99,122,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (437,'HOUSE DYNAMITE','A Taut Story of a Pioneer And a Squirrel who must Battle a Student in Soviet Georgia',2006,7,2.99,109,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (438,'HUMAN GRAFFITI','A Beautiful Reflection of a Womanizer And a Sumo Wrestler who must Chase a Database Administrator in The Gulf of Mexico',2006,3,2.99,68,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (439,'HUNCHBACK IMPOSSIBLE','A Touching Yarn of a Frisbee And a Dentist who must Fight a Composer in Ancient Japan',2006,4,4.99,151,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (440,'HUNGER ROOF','A Unbelieveable Yarn of a Student And a Database Administrator who must Outgun a Husband in An Abandoned Mine Shaft',2006,6,0.99,105,21.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (441,'HUNTER ALTER','A Emotional Drama of a Mad Cow And a Boat who must Redeem a Secret Agent in A Shark Tank',2006,5,2.99,125,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (442,'HUNTING MUSKETEERS','A Thrilling Reflection of a Pioneer And a Dentist who must Outrace a Womanizer in An Abandoned Mine Shaft',2006,6,2.99,65,24.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (443,'HURRICANE AFFAIR','A Lacklusture Epistle of a Database Administrator And a Woman who must Meet a Hunter in An Abandoned Mine Shaft',2006,6,2.99,49,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (444,'HUSTLER PARTY','A Emotional Reflection of a Sumo Wrestler And a Monkey who must Conquer a Robot in The Sahara Desert',2006,3,4.99,83,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (445,'HYDE DOCTOR','A Fanciful Documentary of a Boy And a Woman who must Redeem a Womanizer in A Jet Boat',2006,5,2.99,100,11.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (446,'HYSTERICAL GRAIL','A Amazing Saga of a Madman And a Dentist who must Build a Car in A Manhattan Penthouse',2006,5,4.99,150,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (447,'ICE CROSSING','A Fast-Paced Tale of a Butler And a Moose who must Overcome a Pioneer in A Manhattan Penthouse',2006,5,2.99,131,28.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (448,'IDAHO LOVE','A Fast-Paced Drama of a Student And a Crocodile who must Meet a Database Administrator in The Outback',2006,3,2.99,172,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (449,'IDENTITY LOVER','A Boring Tale of a Composer And a Mad Cow who must Defeat a Car in The Outback',2006,4,2.99,119,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (450,'IDOLS SNATCHERS','A Insightful Drama of a Car And a Composer who must Fight a Man in A Monastery',2006,5,2.99,84,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (451,'IGBY MAKER','A Epic Documentary of a Hunter And a Dog who must Outgun a Dog in A Baloon Factory',2006,7,4.99,160,12.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (452,'ILLUSION AMELIE','A Emotional Epistle of a Boat And a Mad Scientist who must Outrace a Robot in An Abandoned Mine Shaft',2006,4,0.99,122,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (453,'IMAGE PRINCESS','A Lacklusture Panorama of a Secret Agent And a Crocodile who must Discover a Madman in The Canadian Rockies',2006,3,2.99,178,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (454,'IMPACT ALADDIN','A Epic Character Study of a Frisbee And a Moose who must Outgun a Technical Writer in A Shark Tank',2006,6,0.99,180,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (455,'IMPOSSIBLE PREJUDICE','A Awe-Inspiring Yarn of a Monkey And a Hunter who must Chase a Teacher in Ancient China',2006,7,4.99,103,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (456,'INCH JET','A Fateful Saga of a Womanizer And a Student who must Defeat a Butler in A Monastery',2006,6,4.99,167,18.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (457,'INDEPENDENCE HOTEL','A Thrilling Tale of a Technical Writer And a Boy who must Face a Pioneer in A Monastery',2006,5,0.99,157,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (458,'INDIAN LOVE','A Insightful Saga of a Mad Scientist And a Mad Scientist who must Kill a Astronaut in An Abandoned Fun House',2006,4,0.99,135,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (459,'INFORMER DOUBLE','A Action-Packed Display of a Woman And a Dentist who must Redeem a Forensic Psychologist in The Canadian Rockies',2006,4,4.99,74,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (460,'INNOCENT USUAL','A Beautiful Drama of a Pioneer And a Crocodile who must Challenge a Student in The Outback',2006,3,4.99,178,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (461,'INSECTS STONE','A Epic Display of a Butler And a Dog who must Vanquish a Crocodile in A Manhattan Penthouse',2006,3,0.99,123,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (462,'INSIDER ARIZONA','A Astounding Saga of a Mad Scientist And a Hunter who must Pursue a Robot in A Baloon Factory',2006,5,2.99,78,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (463,'INSTINCT AIRPORT','A Touching Documentary of a Mad Cow And a Explorer who must Confront a Butler in A Manhattan Penthouse',2006,4,2.99,116,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (464,'INTENTIONS EMPIRE','A Astounding Epistle of a Cat And a Cat who must Conquer a Mad Cow in A U-Boat',2006,3,2.99,107,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (465,'INTERVIEW LIAISONS','A Action-Packed Reflection of a Student And a Butler who must Discover a Database Administrator in A Manhattan Penthouse',2006,4,4.99,59,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (466,'INTOLERABLE INTENTIONS','A Awe-Inspiring Story of a Monkey And a Pastry Chef who must Succumb a Womanizer in A MySQL Convention',2006,6,4.99,63,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (467,'INTRIGUE WORST','A Fanciful Character Study of a Explorer And a Mad Scientist who must Vanquish a Squirrel in A Jet Boat',2006,6,0.99,181,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (468,'INVASION CYCLONE','A Lacklusture Character Study of a Mad Scientist And a Womanizer who must Outrace a Explorer in A Monastery',2006,5,2.99,97,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (469,'IRON MOON','A Fast-Paced Documentary of a Mad Cow And a Boy who must Pursue a Dentist in A Baloon',2006,7,4.99,46,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (470,'ISHTAR ROCKETEER','A Astounding Saga of a Dog And a Squirrel who must Conquer a Dog in An Abandoned Fun House',2006,4,4.99,79,24.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (471,'ISLAND EXORCIST','A Fanciful Panorama of a Technical Writer And a Boy who must Find a Dentist in An Abandoned Fun House',2006,7,2.99,84,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (472,'ITALIAN AFRICAN','A Astounding Character Study of a Monkey And a Moose who must Outgun a Cat in A U-Boat',2006,3,4.99,174,24.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (473,'JACKET FRISCO','A Insightful Reflection of a Womanizer And a Husband who must Conquer a Pastry Chef in A Baloon',2006,5,2.99,181,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (474,'JADE BUNCH','A Insightful Panorama of a Squirrel And a Mad Cow who must Confront a Student in The First Manned Space Station',2006,6,2.99,174,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (475,'JAPANESE RUN','A Awe-Inspiring Epistle of a Feminist And a Girl who must Sink a Girl in The Outback',2006,6,0.99,135,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (476,'JASON TRAP','A Thoughtful Tale of a Woman And a A Shark who must Conquer a Dog in A Monastery',2006,5,2.99,130,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (477,'JAWBREAKER BROOKLYN','A Stunning Reflection of a Boat And a Pastry Chef who must Succumb a A Shark in A Jet Boat',2006,5,0.99,118,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (478,'JAWS HARRY','A Thrilling Display of a Database Administrator And a Monkey who must Overcome a Dog in An Abandoned Fun House',2006,4,2.99,112,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (479,'JEDI BENEATH','A Astounding Reflection of a Explorer And a Dentist who must Pursue a Student in Nigeria',2006,7,0.99,128,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (480,'JEEPERS WEDDING','A Astounding Display of a Composer And a Dog who must Kill a Pastry Chef in Soviet Georgia',2006,3,2.99,84,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (481,'JEKYLL FROGMEN','A Fanciful Epistle of a Student And a Astronaut who must Kill a Waitress in A Shark Tank',2006,4,2.99,58,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (482,'JEOPARDY ENCINO','A Boring Panorama of a Man And a Mad Cow who must Face a Explorer in Ancient India',2006,3,0.99,102,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (483,'JERICHO MULAN','A Amazing Yarn of a Hunter And a Butler who must Defeat a Boy in A Jet Boat',2006,3,2.99,171,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (484,'JERK PAYCHECK','A Touching Character Study of a Pastry Chef And a Database Administrator who must Reach a A Shark in Ancient Japan',2006,3,2.99,172,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (485,'JERSEY SASSY','A Lacklusture Documentary of a Madman And a Mad Cow who must Find a Feminist in Ancient Japan',2006,6,4.99,60,16.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (486,'JET NEIGHBORS','A Amazing Display of a Lumberjack And a Teacher who must Outrace a Woman in A U-Boat',2006,7,4.99,59,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (487,'JINGLE SAGEBRUSH','A Epic Character Study of a Feminist And a Student who must Meet a Woman in A Baloon',2006,6,4.99,124,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (488,'JOON NORTHWEST','A Thrilling Panorama of a Technical Writer And a Car who must Discover a Forensic Psychologist in A Shark Tank',2006,3,0.99,105,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (489,'JUGGLER HARDLY','A Epic Story of a Mad Cow And a Astronaut who must Challenge a Car in California',2006,4,0.99,54,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (490,'JUMANJI BLADE','A Intrepid Yarn of a Husband And a Womanizer who must Pursue a Mad Scientist in New Orleans',2006,4,2.99,121,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (491,'JUMPING WRATH','A Touching Epistle of a Monkey And a Feminist who must Discover a Boat in Berlin',2006,4,0.99,74,18.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (492,'JUNGLE CLOSER','A Boring Character Study of a Boy And a Woman who must Battle a Astronaut in Australia',2006,6,0.99,134,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (493,'KANE EXORCIST','A Epic Documentary of a Composer And a Robot who must Overcome a Car in Berlin',2006,5,0.99,92,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (494,'KARATE MOON','A Astounding Yarn of a Womanizer And a Dog who must Reach a Waitress in A MySQL Convention',2006,4,0.99,120,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (495,'KENTUCKIAN GIANT','A Stunning Yarn of a Woman And a Frisbee who must Escape a Waitress in A U-Boat',2006,5,2.99,169,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (496,'KICK SAVANNAH','A Emotional Drama of a Monkey And a Robot who must Defeat a Monkey in New Orleans',2006,3,0.99,179,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (497,'KILL BROTHERHOOD','A Touching Display of a Hunter And a Secret Agent who must Redeem a Husband in The Outback',2006,4,0.99,54,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (498,'KILLER INNOCENT','A Fanciful Character Study of a Student And a Explorer who must Succumb a Composer in An Abandoned Mine Shaft',2006,7,2.99,161,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (499,'KING EVOLUTION','A Action-Packed Tale of a Boy And a Lumberjack who must Chase a Madman in A Baloon',2006,3,4.99,184,24.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (500,'KISS GLORY','A Lacklusture Reflection of a Girl And a Husband who must Find a Robot in The Canadian Rockies',2006,5,4.99,163,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (501,'KISSING DOLLS','A Insightful Reflection of a Pioneer And a Teacher who must Build a Composer in The First Manned Space Station',2006,3,4.99,141,9.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (502,'KNOCK WARLOCK','A Unbelieveable Story of a Teacher And a Boat who must Confront a Moose in A Baloon',2006,4,2.99,71,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (503,'KRAMER CHOCOLATE','A Amazing Yarn of a Robot And a Pastry Chef who must Redeem a Mad Scientist in The Outback',2006,3,2.99,171,24.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (504,'KWAI HOMEWARD','A Amazing Drama of a Car And a Squirrel who must Pursue a Car in Soviet Georgia',2006,5,0.99,46,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (505,'LABYRINTH LEAGUE','A Awe-Inspiring Saga of a Composer And a Frisbee who must Succumb a Pioneer in The Sahara Desert',2006,6,2.99,46,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (506,'LADY STAGE','A Beautiful Character Study of a Woman And a Man who must Pursue a Explorer in A U-Boat',2006,4,4.99,67,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (507,'LADYBUGS ARMAGEDDON','A Fateful Reflection of a Dog And a Mad Scientist who must Meet a Mad Scientist in New Orleans',2006,4,0.99,113,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (508,'LAMBS CINCINATTI','A Insightful Story of a Man And a Feminist who must Fight a Composer in Australia',2006,6,4.99,144,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (509,'LANGUAGE COWBOY','A Epic Yarn of a Cat And a Madman who must Vanquish a Dentist in An Abandoned Amusement Park',2006,5,0.99,78,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (510,'LAWLESS VISION','A Insightful Yarn of a Boy And a Sumo Wrestler who must Outgun a Car in The Outback',2006,6,4.99,181,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (511,'LAWRENCE LOVE','A Fanciful Yarn of a Database Administrator And a Mad Cow who must Pursue a Womanizer in Berlin',2006,7,0.99,175,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (512,'LEAGUE HELLFIGHTERS','A Thoughtful Saga of a A Shark And a Monkey who must Outgun a Student in Ancient China',2006,5,4.99,110,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (513,'LEATHERNECKS DWARFS','A Fateful Reflection of a Dog And a Mad Cow who must Outrace a Teacher in An Abandoned Mine Shaft',2006,6,2.99,153,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (514,'LEBOWSKI SOLDIERS','A Beautiful Epistle of a Secret Agent And a Pioneer who must Chase a Astronaut in Ancient China',2006,6,2.99,69,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (515,'LEGALLY SECRETARY','A Astounding Tale of a A Shark And a Moose who must Meet a Womanizer in The Sahara Desert',2006,7,4.99,113,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (516,'LEGEND JEDI','A Awe-Inspiring Epistle of a Pioneer And a Student who must Outgun a Crocodile in The Outback',2006,7,0.99,59,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (517,'LESSON CLEOPATRA','A Emotional Display of a Man And a Explorer who must Build a Boy in A Manhattan Penthouse',2006,3,0.99,167,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (518,'LIAISONS SWEET','A Boring Drama of a A Shark And a Explorer who must Redeem a Waitress in The Canadian Rockies',2006,5,4.99,140,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (519,'LIBERTY MAGNIFICENT','A Boring Drama of a Student And a Cat who must Sink a Technical Writer in A Baloon',2006,3,2.99,138,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (520,'LICENSE WEEKEND','A Insightful Story of a Man And a Husband who must Overcome a Madman in A Monastery',2006,7,2.99,91,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (521,'LIES TREATMENT','A Fast-Paced Character Study of a Dentist And a Moose who must Defeat a Composer in The First Manned Space Station',2006,7,4.99,147,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (522,'LIFE TWISTED','A Thrilling Reflection of a Teacher And a Composer who must Find a Man in The First Manned Space Station',2006,4,2.99,137,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (523,'LIGHTS DEER','A Unbelieveable Epistle of a Dog And a Woman who must Confront a Moose in The Gulf of Mexico',2006,7,0.99,174,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (524,'LION UNCUT','A Intrepid Display of a Pastry Chef And a Cat who must Kill a A Shark in Ancient China',2006,6,0.99,50,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (525,'LOATHING LEGALLY','A Boring Epistle of a Pioneer And a Mad Scientist who must Escape a Frisbee in The Gulf of Mexico',2006,4,0.99,140,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (526,'LOCK REAR','A Thoughtful Character Study of a Squirrel And a Technical Writer who must Outrace a Student in Ancient Japan',2006,7,2.99,120,10.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (527,'LOLA AGENT','A Astounding Tale of a Mad Scientist And a Husband who must Redeem a Database Administrator in Ancient Japan',2006,4,4.99,85,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (528,'LOLITA WORLD','A Thrilling Drama of a Girl And a Robot who must Redeem a Waitress in An Abandoned Mine Shaft',2006,4,2.99,155,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (529,'LONELY ELEPHANT','A Intrepid Story of a Student And a Dog who must Challenge a Explorer in Soviet Georgia',2006,3,2.99,67,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (530,'LORD ARIZONA','A Action-Packed Display of a Frisbee And a Pastry Chef who must Pursue a Crocodile in A Jet Boat',2006,5,2.99,108,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (531,'LOSE INCH','A Stunning Reflection of a Student And a Technical Writer who must Battle a Butler in The First Manned Space Station',2006,3,0.99,137,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (532,'LOSER HUSTLER','A Stunning Drama of a Robot And a Feminist who must Outgun a Butler in Nigeria',2006,5,4.99,80,28.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (533,'LOST BIRD','A Emotional Character Study of a Robot And a A Shark who must Defeat a Technical Writer in A Manhattan Penthouse',2006,4,2.99,98,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (534,'LOUISIANA HARRY','A Lacklusture Drama of a Girl And a Technical Writer who must Redeem a Monkey in A Shark Tank',2006,5,0.99,70,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (535,'LOVE SUICIDES','A Brilliant Panorama of a Hunter And a Explorer who must Pursue a Dentist in An Abandoned Fun House',2006,6,0.99,181,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (536,'LOVELY JINGLE','A Fanciful Yarn of a Crocodile And a Forensic Psychologist who must Discover a Crocodile in The Outback',2006,3,2.99,65,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (537,'LOVER TRUMAN','A Emotional Yarn of a Robot And a Boy who must Outgun a Technical Writer in A U-Boat',2006,3,2.99,75,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (538,'LOVERBOY ATTACKS','A Boring Story of a Car And a Butler who must Build a Girl in Soviet Georgia',2006,7,0.99,162,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (539,'LUCK OPUS','A Boring Display of a Moose And a Squirrel who must Outrace a Teacher in A Shark Tank',2006,7,2.99,152,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (540,'LUCKY FLYING','A Lacklusture Character Study of a A Shark And a Man who must Find a Forensic Psychologist in A U-Boat',2006,7,2.99,97,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (541,'LUKE MUMMY','A Taut Character Study of a Boy And a Robot who must Redeem a Mad Scientist in Ancient India',2006,5,2.99,74,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (542,'LUST LOCK','A Fanciful Panorama of a Hunter And a Dentist who must Meet a Secret Agent in The Sahara Desert',2006,3,2.99,52,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (543,'MADIGAN DORADO','A Astounding Character Study of a A Shark And a A Shark who must Discover a Crocodile in The Outback',2006,5,4.99,116,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (544,'MADISON TRAP','A Awe-Inspiring Reflection of a Monkey And a Dentist who must Overcome a Pioneer in A U-Boat',2006,4,2.99,147,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (545,'MADNESS ATTACKS','A Fanciful Tale of a Squirrel And a Boat who must Defeat a Crocodile in The Gulf of Mexico',2006,4,0.99,178,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (546,'MADRE GABLES','A Intrepid Panorama of a Sumo Wrestler And a Forensic Psychologist who must Discover a Moose in The First Manned Space Station',2006,7,2.99,98,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (547,'MAGIC MALLRATS','A Touching Documentary of a Pastry Chef And a Pastry Chef who must Build a Mad Scientist in California',2006,3,0.99,117,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (548,'MAGNIFICENT CHITTY','A Insightful Story of a Teacher And a Hunter who must Face a Mad Cow in California',2006,3,2.99,53,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (549,'MAGNOLIA FORRESTER','A Thoughtful Documentary of a Composer And a Explorer who must Conquer a Dentist in New Orleans',2006,4,0.99,171,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (550,'MAGUIRE APACHE','A Fast-Paced Reflection of a Waitress And a Hunter who must Defeat a Forensic Psychologist in A Baloon',2006,6,2.99,74,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (551,'MAIDEN HOME','A Lacklusture Saga of a Moose And a Teacher who must Kill a Forensic Psychologist in A MySQL Convention',2006,3,4.99,138,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (552,'MAJESTIC FLOATS','A Thrilling Character Study of a Moose And a Student who must Escape a Butler in The First Manned Space Station',2006,5,0.99,130,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (553,'MAKER GABLES','A Stunning Display of a Moose And a Database Administrator who must Pursue a Composer in A Jet Boat',2006,4,0.99,136,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (554,'MALKOVICH PET','A Intrepid Reflection of a Waitress And a A Shark who must Kill a Squirrel in The Outback',2006,6,2.99,159,22.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (555,'MALLRATS UNITED','A Thrilling Yarn of a Waitress And a Dentist who must Find a Hunter in A Monastery',2006,4,0.99,133,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (556,'MALTESE HOPE','A Fast-Paced Documentary of a Crocodile And a Sumo Wrestler who must Conquer a Explorer in California',2006,6,4.99,127,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (557,'MANCHURIAN CURTAIN','A Stunning Tale of a Mad Cow And a Boy who must Battle a Boy in Berlin',2006,5,2.99,177,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (558,'MANNEQUIN WORST','A Astounding Saga of a Mad Cow And a Pastry Chef who must Discover a Husband in Ancient India',2006,3,2.99,71,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (559,'MARRIED GO','A Fanciful Story of a Womanizer And a Dog who must Face a Forensic Psychologist in The Sahara Desert',2006,7,2.99,114,22.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (560,'MARS ROMAN','A Boring Drama of a Car And a Dog who must Succumb a Madman in Soviet Georgia',2006,6,0.99,62,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (561,'MASK PEACH','A Boring Character Study of a Student And a Robot who must Meet a Woman in California',2006,6,2.99,123,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (562,'MASKED BUBBLE','A Fanciful Documentary of a Pioneer And a Boat who must Pursue a Pioneer in An Abandoned Mine Shaft',2006,6,0.99,151,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (563,'MASSACRE USUAL','A Fateful Reflection of a Waitress And a Crocodile who must Challenge a Forensic Psychologist in California',2006,6,4.99,165,16.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (564,'MASSAGE IMAGE','A Fateful Drama of a Frisbee And a Crocodile who must Vanquish a Dog in The First Manned Space Station',2006,4,2.99,161,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (565,'MATRIX SNOWMAN','A Action-Packed Saga of a Womanizer And a Woman who must Overcome a Student in California',2006,6,4.99,56,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (566,'MAUDE MOD','A Beautiful Documentary of a Forensic Psychologist And a Cat who must Reach a Astronaut in Nigeria',2006,6,0.99,72,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (567,'MEET CHOCOLATE','A Boring Documentary of a Dentist And a Butler who must Confront a Monkey in A MySQL Convention',2006,3,2.99,80,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (568,'MEMENTO ZOOLANDER','A Touching Epistle of a Squirrel And a Explorer who must Redeem a Pastry Chef in The Sahara Desert',2006,4,4.99,77,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (569,'MENAGERIE RUSHMORE','A Unbelieveable Panorama of a Composer And a Butler who must Overcome a Database Administrator in The First Manned Space Station',2006,7,2.99,147,18.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (570,'MERMAID INSECTS','A Lacklusture Drama of a Waitress And a Husband who must Fight a Husband in California',2006,5,4.99,104,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (571,'METAL ARMAGEDDON','A Thrilling Display of a Lumberjack And a Crocodile who must Meet a Monkey in A Baloon Factory',2006,6,2.99,161,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (572,'METROPOLIS COMA','A Emotional Saga of a Database Administrator And a Pastry Chef who must Confront a Teacher in A Baloon Factory',2006,4,2.99,64,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (573,'MICROCOSMOS PARADISE','A Touching Character Study of a Boat And a Student who must Sink a A Shark in Nigeria',2006,6,2.99,105,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (574,'MIDNIGHT WESTWARD','A Taut Reflection of a Husband And a A Shark who must Redeem a Pastry Chef in A Monastery',2006,3,0.99,86,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (575,'MIDSUMMER GROUNDHOG','A Fateful Panorama of a Moose And a Dog who must Chase a Crocodile in Ancient Japan',2006,3,4.99,48,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (576,'MIGHTY LUCK','A Astounding Epistle of a Mad Scientist And a Pioneer who must Escape a Database Administrator in A MySQL Convention',2006,7,2.99,122,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (577,'MILE MULAN','A Lacklusture Epistle of a Cat And a Husband who must Confront a Boy in A MySQL Convention',2006,4,0.99,64,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (578,'MILLION ACE','A Brilliant Documentary of a Womanizer And a Squirrel who must Find a Technical Writer in The Sahara Desert',2006,4,4.99,142,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (579,'MINDS TRUMAN','A Taut Yarn of a Mad Scientist And a Crocodile who must Outgun a Database Administrator in A Monastery',2006,3,4.99,149,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (580,'MINE TITANS','A Amazing Yarn of a Robot And a Womanizer who must Discover a Forensic Psychologist in Berlin',2006,3,4.99,166,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (581,'MINORITY KISS','A Insightful Display of a Lumberjack And a Sumo Wrestler who must Meet a Man in The Outback',2006,4,0.99,59,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (582,'MIRACLE VIRTUAL','A Touching Epistle of a Butler And a Boy who must Find a Mad Scientist in The Sahara Desert',2006,3,2.99,162,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (583,'MISSION ZOOLANDER','A Intrepid Story of a Sumo Wrestler And a Teacher who must Meet a A Shark in An Abandoned Fun House',2006,3,4.99,164,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (584,'MIXED DOORS','A Taut Drama of a Womanizer And a Lumberjack who must Succumb a Pioneer in Ancient India',2006,6,2.99,180,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (585,'MOB DUFFEL','A Unbelieveable Documentary of a Frisbee And a Boat who must Meet a Boy in The Canadian Rockies',2006,4,0.99,105,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (586,'MOCKINGBIRD HOLLYWOOD','A Thoughtful Panorama of a Man And a Car who must Sink a Composer in Berlin',2006,4,0.99,60,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (587,'MOD SECRETARY','A Boring Documentary of a Mad Cow And a Cat who must Build a Lumberjack in New Orleans',2006,6,4.99,77,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (588,'MODEL FISH','A Beautiful Panorama of a Boat And a Crocodile who must Outrace a Dog in Australia',2006,4,4.99,175,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (589,'MODERN DORADO','A Awe-Inspiring Story of a Butler And a Sumo Wrestler who must Redeem a Boy in New Orleans',2006,3,0.99,74,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (590,'MONEY HAROLD','A Touching Tale of a Explorer And a Boat who must Defeat a Robot in Australia',2006,3,2.99,135,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (591,'MONSOON CAUSE','A Astounding Tale of a Crocodile And a Car who must Outrace a Squirrel in A U-Boat',2006,6,4.99,182,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (592,'MONSTER SPARTACUS','A Fast-Paced Story of a Waitress And a Cat who must Fight a Girl in Australia',2006,6,2.99,107,28.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (593,'MONTEREY LABYRINTH','A Awe-Inspiring Drama of a Monkey And a Composer who must Escape a Feminist in A U-Boat',2006,6,0.99,158,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (594,'MONTEZUMA COMMAND','A Thrilling Reflection of a Waitress And a Butler who must Battle a Butler in A Jet Boat',2006,6,0.99,126,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (595,'MOON BUNCH','A Beautiful Tale of a Astronaut And a Mad Cow who must Challenge a Cat in A Baloon Factory',2006,7,0.99,83,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (596,'MOONSHINE CABIN','A Thoughtful Display of a Astronaut And a Feminist who must Chase a Frisbee in A Jet Boat',2006,4,4.99,171,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (597,'MOONWALKER FOOL','A Epic Drama of a Feminist And a Pioneer who must Sink a Composer in New Orleans',2006,5,4.99,184,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (598,'MOSQUITO ARMAGEDDON','A Thoughtful Character Study of a Waitress And a Feminist who must Build a Teacher in Ancient Japan',2006,6,0.99,57,22.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (599,'MOTHER OLEANDER','A Boring Tale of a Husband And a Boy who must Fight a Squirrel in Ancient China',2006,3,0.99,103,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (600,'MOTIONS DETAILS','A Awe-Inspiring Reflection of a Dog And a Student who must Kill a Car in An Abandoned Fun House',2006,5,0.99,166,16.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (601,'MOULIN WAKE','A Astounding Story of a Forensic Psychologist And a Cat who must Battle a Teacher in An Abandoned Mine Shaft',2006,4,0.99,79,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (602,'MOURNING PURPLE','A Lacklusture Display of a Waitress And a Lumberjack who must Chase a Pioneer in New Orleans',2006,5,0.99,146,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (603,'MOVIE SHAKESPEARE','A Insightful Display of a Database Administrator And a Student who must Build a Hunter in Berlin',2006,6,4.99,53,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (604,'MULAN MOON','A Emotional Saga of a Womanizer And a Pioneer who must Overcome a Dentist in A Baloon',2006,4,0.99,160,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (605,'MULHOLLAND BEAST','A Awe-Inspiring Display of a Husband And a Squirrel who must Battle a Sumo Wrestler in A Jet Boat',2006,7,2.99,157,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (606,'MUMMY CREATURES','A Fateful Character Study of a Crocodile And a Monkey who must Meet a Dentist in Australia',2006,3,0.99,160,15.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (607,'MUPPET MILE','A Lacklusture Story of a Madman And a Teacher who must Kill a Frisbee in The Gulf of Mexico',2006,5,4.99,50,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (608,'MURDER ANTITRUST','A Brilliant Yarn of a Car And a Database Administrator who must Escape a Boy in A MySQL Convention',2006,6,2.99,166,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (609,'MUSCLE BRIGHT','A Stunning Panorama of a Sumo Wrestler And a Husband who must Redeem a Madman in Ancient India',2006,7,2.99,185,23.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (610,'MUSIC BOONDOCK','A Thrilling Tale of a Butler And a Astronaut who must Battle a Explorer in The First Manned Space Station',2006,7,0.99,129,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (611,'MUSKETEERS WAIT','A Touching Yarn of a Student And a Moose who must Fight a Mad Cow in Australia',2006,7,4.99,73,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (612,'MUSSOLINI SPOILERS','A Thrilling Display of a Boat And a Monkey who must Meet a Composer in Ancient China',2006,6,2.99,180,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (613,'MYSTIC TRUMAN','A Epic Yarn of a Teacher And a Hunter who must Outgun a Explorer in Soviet Georgia',2006,5,0.99,92,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (614,'NAME DETECTIVE','A Touching Saga of a Sumo Wrestler And a Cat who must Pursue a Mad Scientist in Nigeria',2006,5,4.99,178,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (615,'NASH CHOCOLAT','A Epic Reflection of a Monkey And a Mad Cow who must Kill a Forensic Psychologist in An Abandoned Mine Shaft',2006,6,2.99,180,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (616,'NATIONAL STORY','A Taut Epistle of a Mad Scientist And a Girl who must Escape a Monkey in California',2006,4,2.99,92,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (617,'NATURAL STOCK','A Fast-Paced Story of a Sumo Wrestler And a Girl who must Defeat a Car in A Baloon Factory',2006,4,0.99,50,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (618,'NECKLACE OUTBREAK','A Astounding Epistle of a Database Administrator And a Mad Scientist who must Pursue a Cat in California',2006,3,0.99,132,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (619,'NEIGHBORS CHARADE','A Fanciful Reflection of a Crocodile And a Astronaut who must Outrace a Feminist in An Abandoned Amusement Park',2006,3,0.99,161,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (620,'NEMO CAMPUS','A Lacklusture Reflection of a Monkey And a Squirrel who must Outrace a Womanizer in A Manhattan Penthouse',2006,5,2.99,131,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (621,'NETWORK PEAK','A Unbelieveable Reflection of a Butler And a Boat who must Outgun a Mad Scientist in California',2006,5,2.99,75,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (622,'NEWSIES STORY','A Action-Packed Character Study of a Dog And a Lumberjack who must Outrace a Moose in The Gulf of Mexico',2006,4,0.99,159,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (623,'NEWTON LABYRINTH','A Intrepid Character Study of a Moose And a Waitress who must Find a A Shark in Ancient India',2006,4,0.99,75,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (624,'NIGHTMARE CHILL','A Brilliant Display of a Robot And a Butler who must Fight a Waitress in An Abandoned Mine Shaft',2006,3,4.99,149,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (625,'NONE SPIKING','A Boring Reflection of a Secret Agent And a Astronaut who must Face a Composer in A Manhattan Penthouse',2006,3,0.99,83,18.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (626,'NOON PAPI','A Unbelieveable Character Study of a Mad Scientist And a Astronaut who must Find a Pioneer in A Manhattan Penthouse',2006,5,2.99,57,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (627,'NORTH TEQUILA','A Beautiful Character Study of a Mad Cow And a Robot who must Reach a Womanizer in New Orleans',2006,4,4.99,67,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (628,'NORTHWEST POLISH','A Boring Character Study of a Boy And a A Shark who must Outrace a Womanizer in The Outback',2006,5,2.99,172,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (629,'NOTORIOUS REUNION','A Amazing Epistle of a Woman And a Squirrel who must Fight a Hunter in A Baloon',2006,7,0.99,128,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (630,'NOTTING SPEAKEASY','A Thoughtful Display of a Butler And a Womanizer who must Find a Waitress in The Canadian Rockies',2006,7,0.99,48,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (631,'NOVOCAINE FLIGHT','A Fanciful Display of a Student And a Teacher who must Outgun a Crocodile in Nigeria',2006,4,0.99,64,11.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (632,'NUTS TIES','A Thoughtful Drama of a Explorer And a Womanizer who must Meet a Teacher in California',2006,5,4.99,145,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (633,'OCTOBER SUBMARINE','A Taut Epistle of a Monkey And a Boy who must Confront a Husband in A Jet Boat',2006,6,4.99,54,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (634,'ODDS BOOGIE','A Thrilling Yarn of a Feminist And a Madman who must Battle a Hunter in Berlin',2006,6,0.99,48,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (635,'OKLAHOMA JUMANJI','A Thoughtful Drama of a Dentist And a Womanizer who must Meet a Husband in The Sahara Desert',2006,7,0.99,58,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (636,'OLEANDER CLUE','A Boring Story of a Teacher And a Monkey who must Succumb a Forensic Psychologist in A Jet Boat',2006,5,0.99,161,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (637,'OPEN AFRICAN','A Lacklusture Drama of a Secret Agent And a Explorer who must Discover a Car in A U-Boat',2006,7,4.99,131,16.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (638,'OPERATION OPERATION','A Intrepid Character Study of a Man And a Frisbee who must Overcome a Madman in Ancient China',2006,7,2.99,156,23.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (639,'OPPOSITE NECKLACE','A Fateful Epistle of a Crocodile And a Moose who must Kill a Explorer in Nigeria',2006,7,4.99,92,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (640,'OPUS ICE','A Fast-Paced Drama of a Hunter And a Boy who must Discover a Feminist in The Sahara Desert',2006,5,4.99,102,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (641,'ORANGE GRAPES','A Astounding Documentary of a Butler And a Womanizer who must Face a Dog in A U-Boat',2006,4,0.99,76,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (642,'ORDER BETRAYED','A Amazing Saga of a Dog And a A Shark who must Challenge a Cat in The Sahara Desert',2006,7,2.99,120,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (643,'ORIENT CLOSER','A Astounding Epistle of a Technical Writer And a Teacher who must Fight a Squirrel in The Sahara Desert',2006,3,2.99,118,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (644,'OSCAR GOLD','A Insightful Tale of a Database Administrator And a Dog who must Face a Madman in Soviet Georgia',2006,7,2.99,115,29.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (645,'OTHERS SOUP','A Lacklusture Documentary of a Mad Cow And a Madman who must Sink a Moose in The Gulf of Mexico',2006,7,2.99,118,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (646,'OUTBREAK DIVINE','A Unbelieveable Yarn of a Database Administrator And a Woman who must Succumb a A Shark in A U-Boat',2006,6,0.99,169,12.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (647,'OUTFIELD MASSACRE','A Thoughtful Drama of a Husband And a Secret Agent who must Pursue a Database Administrator in Ancient India',2006,4,0.99,129,18.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (648,'OUTLAW HANKY','A Thoughtful Story of a Astronaut And a Composer who must Conquer a Dog in The Sahara Desert',2006,7,4.99,148,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (649,'OZ LIAISONS','A Epic Yarn of a Mad Scientist And a Cat who must Confront a Womanizer in A Baloon Factory',2006,4,2.99,85,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (650,'PACIFIC AMISTAD','A Thrilling Yarn of a Dog And a Moose who must Kill a Pastry Chef in A Manhattan Penthouse',2006,3,0.99,144,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (651,'PACKER MADIGAN','A Epic Display of a Sumo Wrestler And a Forensic Psychologist who must Build a Woman in An Abandoned Amusement Park',2006,3,0.99,84,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (652,'PAJAMA JAWBREAKER','A Emotional Drama of a Boy And a Technical Writer who must Redeem a Sumo Wrestler in California',2006,3,0.99,126,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (653,'PANIC CLUB','A Fanciful Display of a Teacher And a Crocodile who must Succumb a Girl in A Baloon',2006,3,4.99,102,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (654,'PANKY SUBMARINE','A Touching Documentary of a Dentist And a Sumo Wrestler who must Overcome a Boy in The Gulf of Mexico',2006,4,4.99,93,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (655,'PANTHER REDS','A Brilliant Panorama of a Moose And a Man who must Reach a Teacher in The Gulf of Mexico',2006,5,4.99,109,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (656,'PAPI NECKLACE','A Fanciful Display of a Car And a Monkey who must Escape a Squirrel in Ancient Japan',2006,3,0.99,128,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (657,'PARADISE SABRINA','A Intrepid Yarn of a Car And a Moose who must Outrace a Crocodile in A Manhattan Penthouse',2006,5,2.99,48,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (658,'PARIS WEEKEND','A Intrepid Story of a Squirrel And a Crocodile who must Defeat a Monkey in The Outback',2006,7,2.99,121,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (659,'PARK CITIZEN','A Taut Epistle of a Sumo Wrestler And a Girl who must Face a Husband in Ancient Japan',2006,3,4.99,109,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (660,'PARTY KNOCK','A Fateful Display of a Technical Writer And a Butler who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,7,2.99,107,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (661,'PAST SUICIDES','A Intrepid Tale of a Madman And a Astronaut who must Challenge a Hunter in A Monastery',2006,5,4.99,157,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (662,'PATHS CONTROL','A Astounding Documentary of a Butler And a Cat who must Find a Frisbee in Ancient China',2006,3,4.99,118,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (663,'PATIENT SISTER','A Emotional Epistle of a Squirrel And a Robot who must Confront a Lumberjack in Soviet Georgia',2006,7,0.99,99,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (664,'PATRIOT ROMAN','A Taut Saga of a Robot And a Database Administrator who must Challenge a Astronaut in California',2006,6,2.99,65,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (665,'PATTON INTERVIEW','A Thrilling Documentary of a Composer And a Secret Agent who must Succumb a Cat in Berlin',2006,4,2.99,175,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (666,'PAYCHECK WAIT','A Awe-Inspiring Reflection of a Boy And a Man who must Discover a Moose in The Sahara Desert',2006,4,4.99,145,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (667,'PEACH INNOCENT','A Action-Packed Drama of a Monkey And a Dentist who must Chase a Butler in Berlin',2006,3,2.99,160,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (668,'PEAK FOREVER','A Insightful Reflection of a Boat And a Secret Agent who must Vanquish a Astronaut in An Abandoned Mine Shaft',2006,7,4.99,80,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (669,'PEARL DESTINY','A Lacklusture Yarn of a Astronaut And a Pastry Chef who must Sink a Dog in A U-Boat',2006,3,2.99,74,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (670,'PELICAN COMFORTS','A Epic Documentary of a Boy And a Monkey who must Pursue a Astronaut in Berlin',2006,4,4.99,48,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (671,'PERDITION FARGO','A Fast-Paced Story of a Car And a Cat who must Outgun a Hunter in Berlin',2006,7,4.99,99,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (672,'PERFECT GROOVE','A Thrilling Yarn of a Dog And a Dog who must Build a Husband in A Baloon',2006,7,2.99,82,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (673,'PERSONAL LADYBUGS','A Epic Saga of a Hunter And a Technical Writer who must Conquer a Cat in Ancient Japan',2006,3,0.99,118,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (674,'PET HAUNTING','A Unbelieveable Reflection of a Explorer And a Boat who must Conquer a Woman in California',2006,3,0.99,99,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (675,'PHANTOM GLORY','A Beautiful Documentary of a Astronaut And a Crocodile who must Discover a Madman in A Monastery',2006,6,2.99,60,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (676,'PHILADELPHIA WIFE','A Taut Yarn of a Hunter And a Astronaut who must Conquer a Database Administrator in The Sahara Desert',2006,7,4.99,137,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (677,'PIANIST OUTFIELD','A Intrepid Story of a Boy And a Technical Writer who must Pursue a Lumberjack in A Monastery',2006,6,0.99,136,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (678,'PICKUP DRIVING','A Touching Documentary of a Husband And a Boat who must Meet a Pastry Chef in A Baloon Factory',2006,3,2.99,77,23.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (679,'PILOT HOOSIERS','A Awe-Inspiring Reflection of a Crocodile And a Sumo Wrestler who must Meet a Forensic Psychologist in An Abandoned Mine Shaft',2006,6,2.99,50,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (680,'PINOCCHIO SIMON','A Action-Packed Reflection of a Mad Scientist And a A Shark who must Find a Feminist in California',2006,4,4.99,103,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (681,'PIRATES ROXANNE','A Stunning Drama of a Woman And a Lumberjack who must Overcome a A Shark in The Canadian Rockies',2006,4,0.99,100,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (682,'PITTSBURGH HUNCHBACK','A Thrilling Epistle of a Boy And a Boat who must Find a Student in Soviet Georgia',2006,4,4.99,134,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (683,'PITY BOUND','A Boring Panorama of a Feminist And a Moose who must Defeat a Database Administrator in Nigeria',2006,5,4.99,60,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (684,'PIZZA JUMANJI','A Epic Saga of a Cat And a Squirrel who must Outgun a Robot in A U-Boat',2006,4,2.99,173,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (685,'PLATOON INSTINCT','A Thrilling Panorama of a Man And a Woman who must Reach a Woman in Australia',2006,6,4.99,132,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (686,'PLUTO OLEANDER','A Action-Packed Reflection of a Car And a Moose who must Outgun a Car in A Shark Tank',2006,5,4.99,84,9.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (687,'POCUS PULP','A Intrepid Yarn of a Frisbee And a Dog who must Build a Astronaut in A Baloon Factory',2006,6,0.99,138,15.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (688,'POLISH BROOKLYN','A Boring Character Study of a Database Administrator And a Lumberjack who must Reach a Madman in The Outback',2006,6,0.99,61,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (689,'POLLOCK DELIVERANCE','A Intrepid Story of a Madman And a Frisbee who must Outgun a Boat in The Sahara Desert',2006,5,2.99,137,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (690,'POND SEATTLE','A Stunning Drama of a Teacher And a Boat who must Battle a Feminist in Ancient China',2006,7,2.99,185,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (691,'POSEIDON FOREVER','A Thoughtful Epistle of a Womanizer And a Monkey who must Vanquish a Dentist in A Monastery',2006,6,4.99,159,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (692,'POTLUCK MIXED','A Beautiful Story of a Dog And a Technical Writer who must Outgun a Student in A Baloon',2006,3,2.99,179,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (693,'POTTER CONNECTICUT','A Thrilling Epistle of a Frisbee And a Cat who must Fight a Technical Writer in Berlin',2006,5,2.99,115,16.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (694,'PREJUDICE OLEANDER','A Epic Saga of a Boy And a Dentist who must Outrace a Madman in A U-Boat',2006,6,4.99,98,15.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (695,'PRESIDENT BANG','A Fateful Panorama of a Technical Writer And a Moose who must Battle a Robot in Soviet Georgia',2006,6,4.99,144,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (696,'PRIDE ALAMO','A Thoughtful Drama of a A Shark And a Forensic Psychologist who must Vanquish a Student in Ancient India',2006,6,0.99,114,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (697,'PRIMARY GLASS','A Fateful Documentary of a Pastry Chef And a Butler who must Build a Dog in The Canadian Rockies',2006,7,0.99,53,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (698,'PRINCESS GIANT','A Thrilling Yarn of a Pastry Chef And a Monkey who must Battle a Monkey in A Shark Tank',2006,3,2.99,71,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (699,'PRIVATE DROP','A Stunning Story of a Technical Writer And a Hunter who must Succumb a Secret Agent in A Baloon',2006,7,4.99,106,26.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (700,'PRIX UNDEFEATED','A Stunning Saga of a Mad Scientist And a Boat who must Overcome a Dentist in Ancient China',2006,4,2.99,115,13.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (701,'PSYCHO SHRUNK','A Amazing Panorama of a Crocodile And a Explorer who must Fight a Husband in Nigeria',2006,5,2.99,155,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (702,'PULP BEVERLY','A Unbelieveable Display of a Dog And a Crocodile who must Outrace a Man in Nigeria',2006,4,2.99,89,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (703,'PUNK DIVORCE','A Fast-Paced Tale of a Pastry Chef And a Boat who must Face a Frisbee in The Canadian Rockies',2006,6,4.99,100,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (704,'PURE RUNNER','A Thoughtful Documentary of a Student And a Madman who must Challenge a Squirrel in A Manhattan Penthouse',2006,3,2.99,121,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (705,'PURPLE MOVIE','A Boring Display of a Pastry Chef And a Sumo Wrestler who must Discover a Frisbee in An Abandoned Amusement Park',2006,4,2.99,88,9.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (706,'QUEEN LUKE','A Astounding Story of a Girl And a Boy who must Challenge a Composer in New Orleans',2006,5,4.99,163,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (707,'QUEST MUSSOLINI','A Fateful Drama of a Husband And a Sumo Wrestler who must Battle a Pastry Chef in A Baloon Factory',2006,5,2.99,177,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (708,'QUILLS BULL','A Thoughtful Story of a Pioneer And a Woman who must Reach a Moose in Australia',2006,4,4.99,112,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (709,'RACER EGG','A Emotional Display of a Monkey And a Waitress who must Reach a Secret Agent in California',2006,7,2.99,147,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (710,'RAGE GAMES','A Fast-Paced Saga of a Astronaut And a Secret Agent who must Escape a Hunter in An Abandoned Amusement Park',2006,4,4.99,120,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (711,'RAGING AIRPLANE','A Astounding Display of a Secret Agent And a Technical Writer who must Escape a Mad Scientist in A Jet Boat',2006,4,4.99,154,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (712,'RAIDERS ANTITRUST','A Amazing Drama of a Teacher And a Feminist who must Meet a Woman in The First Manned Space Station',2006,4,0.99,82,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (713,'RAINBOW SHOCK','A Action-Packed Story of a Hunter And a Boy who must Discover a Lumberjack in Ancient India',2006,3,4.99,74,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (714,'RANDOM GO','A Fateful Drama of a Frisbee And a Student who must Confront a Cat in A Shark Tank',2006,6,2.99,73,29.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (715,'RANGE MOONWALKER','A Insightful Documentary of a Hunter And a Dentist who must Confront a Crocodile in A Baloon',2006,3,4.99,147,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (716,'REAP UNFAITHFUL','A Thrilling Epistle of a Composer And a Sumo Wrestler who must Challenge a Mad Cow in A MySQL Convention',2006,6,2.99,136,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (717,'REAR TRADING','A Awe-Inspiring Reflection of a Forensic Psychologist And a Secret Agent who must Succumb a Pastry Chef in Soviet Georgia',2006,6,0.99,97,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (718,'REBEL AIRPORT','A Intrepid Yarn of a Database Administrator And a Boat who must Outrace a Husband in Ancient India',2006,7,0.99,73,24.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (719,'RECORDS ZORRO','A Amazing Drama of a Mad Scientist And a Composer who must Build a Husband in The Outback',2006,7,4.99,182,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (720,'REDEMPTION COMFORTS','A Emotional Documentary of a Dentist And a Woman who must Battle a Mad Scientist in Ancient China',2006,3,2.99,179,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (721,'REDS POCUS','A Lacklusture Yarn of a Sumo Wrestler And a Squirrel who must Redeem a Monkey in Soviet Georgia',2006,7,4.99,182,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (722,'REEF SALUTE','A Action-Packed Saga of a Teacher And a Lumberjack who must Battle a Dentist in A Baloon',2006,5,0.99,123,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (723,'REIGN GENTLEMEN','A Emotional Yarn of a Composer And a Man who must Escape a Butler in The Gulf of Mexico',2006,3,2.99,82,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (724,'REMEMBER DIARY','A Insightful Tale of a Technical Writer And a Waitress who must Conquer a Monkey in Ancient India',2006,5,2.99,110,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (725,'REQUIEM TYCOON','A Unbelieveable Character Study of a Cat And a Database Administrator who must Pursue a Teacher in A Monastery',2006,6,4.99,167,25.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (726,'RESERVOIR ADAPTATION','A Intrepid Drama of a Teacher And a Moose who must Kill a Car in California',2006,7,2.99,61,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (727,'RESURRECTION SILVERADO','A Epic Yarn of a Robot And a Explorer who must Challenge a Girl in A MySQL Convention',2006,6,0.99,117,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (728,'REUNION WITCHES','A Unbelieveable Documentary of a Database Administrator And a Frisbee who must Redeem a Mad Scientist in A Baloon Factory',2006,3,0.99,63,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (729,'RIDER CADDYSHACK','A Taut Reflection of a Monkey And a Womanizer who must Chase a Moose in Nigeria',2006,5,2.99,177,28.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (730,'RIDGEMONT SUBMARINE','A Unbelieveable Drama of a Waitress And a Composer who must Sink a Mad Cow in Ancient Japan',2006,3,0.99,46,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (731,'RIGHT CRANES','A Fateful Character Study of a Boat And a Cat who must Find a Database Administrator in A Jet Boat',2006,7,4.99,153,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (732,'RINGS HEARTBREAKERS','A Amazing Yarn of a Sumo Wrestler And a Boat who must Conquer a Waitress in New Orleans',2006,5,0.99,58,17.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (733,'RIVER OUTLAW','A Thrilling Character Study of a Squirrel And a Lumberjack who must Face a Hunter in A MySQL Convention',2006,4,0.99,149,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (734,'ROAD ROXANNE','A Boring Character Study of a Waitress And a Astronaut who must Fight a Crocodile in Ancient Japan',2006,4,4.99,158,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (735,'ROBBERS JOON','A Thoughtful Story of a Mad Scientist And a Waitress who must Confront a Forensic Psychologist in Soviet Georgia',2006,7,2.99,102,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (736,'ROBBERY BRIGHT','A Taut Reflection of a Robot And a Squirrel who must Fight a Boat in Ancient Japan',2006,4,0.99,134,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (737,'ROCK INSTINCT','A Astounding Character Study of a Robot And a Moose who must Overcome a Astronaut in Ancient India',2006,4,0.99,102,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (738,'ROCKETEER MOTHER','A Awe-Inspiring Character Study of a Robot And a Sumo Wrestler who must Discover a Womanizer in A Shark Tank',2006,3,0.99,178,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (739,'ROCKY WAR','A Fast-Paced Display of a Squirrel And a Explorer who must Outgun a Mad Scientist in Nigeria',2006,4,4.99,145,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (740,'ROLLERCOASTER BRINGING','A Beautiful Drama of a Robot And a Lumberjack who must Discover a Technical Writer in A Shark Tank',2006,5,2.99,153,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (741,'ROMAN PUNK','A Thoughtful Panorama of a Mad Cow And a Student who must Battle a Forensic Psychologist in Berlin',2006,7,0.99,81,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (742,'ROOF CHAMPION','A Lacklusture Reflection of a Car And a Explorer who must Find a Monkey in A Baloon',2006,7,0.99,101,25.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (743,'ROOM ROMAN','A Awe-Inspiring Panorama of a Composer And a Secret Agent who must Sink a Composer in A Shark Tank',2006,7,0.99,60,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (744,'ROOTS REMEMBER','A Brilliant Drama of a Mad Cow And a Hunter who must Escape a Hunter in Berlin',2006,4,0.99,89,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (745,'ROSES TREASURE','A Astounding Panorama of a Monkey And a Secret Agent who must Defeat a Woman in The First Manned Space Station',2006,5,4.99,162,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (746,'ROUGE SQUAD','A Awe-Inspiring Drama of a Astronaut And a Frisbee who must Conquer a Mad Scientist in Australia',2006,3,0.99,118,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (747,'ROXANNE REBEL','A Astounding Story of a Pastry Chef And a Database Administrator who must Fight a Man in The Outback',2006,5,0.99,171,9.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (748,'RUGRATS SHAKESPEARE','A Touching Saga of a Crocodile And a Crocodile who must Discover a Technical Writer in Nigeria',2006,4,0.99,109,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (749,'RULES HUMAN','A Beautiful Epistle of a Astronaut And a Student who must Confront a Monkey in An Abandoned Fun House',2006,6,4.99,153,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (750,'RUN PACIFIC','A Touching Tale of a Cat And a Pastry Chef who must Conquer a Pastry Chef in A MySQL Convention',2006,3,0.99,145,25.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (751,'RUNAWAY TENENBAUMS','A Thoughtful Documentary of a Boat And a Man who must Meet a Boat in An Abandoned Fun House',2006,6,0.99,181,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (752,'RUNNER MADIGAN','A Thoughtful Documentary of a Crocodile And a Robot who must Outrace a Womanizer in The Outback',2006,6,0.99,101,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (753,'RUSH GOODFELLAS','A Emotional Display of a Man And a Dentist who must Challenge a Squirrel in Australia',2006,3,0.99,48,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (754,'RUSHMORE MERMAID','A Boring Story of a Woman And a Moose who must Reach a Husband in A Shark Tank',2006,6,2.99,150,17.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (755,'SABRINA MIDNIGHT','A Emotional Story of a Squirrel And a Crocodile who must Succumb a Husband in The Sahara Desert',2006,5,4.99,99,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (756,'SADDLE ANTITRUST','A Stunning Epistle of a Feminist And a A Shark who must Battle a Woman in An Abandoned Fun House',2006,7,2.99,80,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (757,'SAGEBRUSH CLUELESS','A Insightful Story of a Lumberjack And a Hunter who must Kill a Boy in Ancient Japan',2006,4,2.99,106,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (758,'SAINTS BRIDE','A Fateful Tale of a Technical Writer And a Composer who must Pursue a Explorer in The Gulf of Mexico',2006,5,2.99,125,11.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (759,'SALUTE APOLLO','A Awe-Inspiring Character Study of a Boy And a Feminist who must Sink a Crocodile in Ancient China',2006,4,2.99,73,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (760,'SAMURAI LION','A Fast-Paced Story of a Pioneer And a Astronaut who must Reach a Boat in A Baloon',2006,5,2.99,110,21.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (761,'SANTA PARIS','A Emotional Documentary of a Moose And a Car who must Redeem a Mad Cow in A Baloon Factory',2006,7,2.99,154,23.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (762,'SASSY PACKER','A Fast-Paced Documentary of a Dog And a Teacher who must Find a Moose in A Manhattan Penthouse',2006,6,0.99,154,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (763,'SATISFACTION CONFIDENTIAL','A Lacklusture Yarn of a Dentist And a Butler who must Meet a Secret Agent in Ancient China',2006,3,4.99,75,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (764,'SATURDAY LAMBS','A Thoughtful Reflection of a Mad Scientist And a Moose who must Kill a Husband in A Baloon',2006,3,4.99,150,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (765,'SATURN NAME','A Fateful Epistle of a Butler And a Boy who must Redeem a Teacher in Berlin',2006,7,4.99,182,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (766,'SAVANNAH TOWN','A Awe-Inspiring Tale of a Astronaut And a Database Administrator who must Chase a Secret Agent in The Gulf of Mexico',2006,5,0.99,84,25.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (767,'SCALAWAG DUCK','A Fateful Reflection of a Car And a Teacher who must Confront a Waitress in A Monastery',2006,6,4.99,183,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (768,'SCARFACE BANG','A Emotional Yarn of a Teacher And a Girl who must Find a Teacher in A Baloon Factory',2006,3,4.99,102,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (769,'SCHOOL JACKET','A Intrepid Yarn of a Monkey And a Boy who must Fight a Composer in A Manhattan Penthouse',2006,5,4.99,151,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (770,'SCISSORHANDS SLUMS','A Awe-Inspiring Drama of a Girl And a Technical Writer who must Meet a Feminist in The Canadian Rockies',2006,5,2.99,147,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (771,'SCORPION APOLLO','A Awe-Inspiring Documentary of a Technical Writer And a Husband who must Meet a Monkey in An Abandoned Fun House',2006,3,4.99,137,23.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (772,'SEA VIRGIN','A Fast-Paced Documentary of a Technical Writer And a Pastry Chef who must Escape a Moose in A U-Boat',2006,4,2.99,80,24.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (773,'SEABISCUIT PUNK','A Insightful Saga of a Man And a Forensic Psychologist who must Discover a Mad Cow in A MySQL Convention',2006,6,2.99,112,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (774,'SEARCHERS WAIT','A Fast-Paced Tale of a Car And a Mad Scientist who must Kill a Womanizer in Ancient Japan',2006,3,2.99,182,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (775,'SEATTLE EXPECATIONS','A Insightful Reflection of a Crocodile And a Sumo Wrestler who must Meet a Technical Writer in The Sahara Desert',2006,4,4.99,110,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (776,'SECRET GROUNDHOG','A Astounding Story of a Cat And a Database Administrator who must Build a Technical Writer in New Orleans',2006,6,4.99,90,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (777,'SECRETARY ROUGE','A Action-Packed Panorama of a Mad Cow And a Composer who must Discover a Robot in A Baloon Factory',2006,5,4.99,158,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (778,'SECRETS PARADISE','A Fateful Saga of a Cat And a Frisbee who must Kill a Girl in A Manhattan Penthouse',2006,3,4.99,109,24.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (779,'SENSE GREEK','A Taut Saga of a Lumberjack And a Pastry Chef who must Escape a Sumo Wrestler in An Abandoned Fun House',2006,4,4.99,54,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (780,'SENSIBILITY REAR','A Emotional Tale of a Robot And a Sumo Wrestler who must Redeem a Pastry Chef in A Baloon Factory',2006,7,4.99,98,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (781,'SEVEN SWARM','A Unbelieveable Character Study of a Dog And a Mad Cow who must Kill a Monkey in Berlin',2006,4,4.99,127,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (782,'SHAKESPEARE SADDLE','A Fast-Paced Panorama of a Lumberjack And a Database Administrator who must Defeat a Madman in A MySQL Convention',2006,6,2.99,60,26.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (783,'SHANE DARKNESS','A Action-Packed Saga of a Moose And a Lumberjack who must Find a Woman in Berlin',2006,5,2.99,93,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (784,'SHANGHAI TYCOON','A Fast-Paced Character Study of a Crocodile And a Lumberjack who must Build a Husband in An Abandoned Fun House',2006,7,2.99,47,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (785,'SHAWSHANK BUBBLE','A Lacklusture Story of a Moose And a Monkey who must Confront a Butler in An Abandoned Amusement Park',2006,6,4.99,80,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (786,'SHEPHERD MIDSUMMER','A Thoughtful Drama of a Robot And a Womanizer who must Kill a Lumberjack in A Baloon',2006,7,0.99,113,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (787,'SHINING ROSES','A Awe-Inspiring Character Study of a Astronaut And a Forensic Psychologist who must Challenge a Madman in Ancient India',2006,4,0.99,125,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (788,'SHIP WONDERLAND','A Thrilling Saga of a Monkey And a Frisbee who must Escape a Explorer in The Outback',2006,5,2.99,104,15.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (789,'SHOCK CABIN','A Fateful Tale of a Mad Cow And a Crocodile who must Meet a Husband in New Orleans',2006,7,2.99,79,15.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (790,'SHOOTIST SUPERFLY','A Fast-Paced Story of a Crocodile And a A Shark who must Sink a Pioneer in Berlin',2006,6,0.99,67,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (791,'SHOW LORD','A Fanciful Saga of a Student And a Girl who must Find a Butler in Ancient Japan',2006,3,4.99,167,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (792,'SHREK LICENSE','A Fateful Yarn of a Secret Agent And a Feminist who must Find a Feminist in A Jet Boat',2006,7,2.99,154,15.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (793,'SHRUNK DIVINE','A Fateful Character Study of a Waitress And a Technical Writer who must Battle a Hunter in A Baloon',2006,6,2.99,139,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (794,'SIDE ARK','A Stunning Panorama of a Crocodile And a Womanizer who must Meet a Feminist in The Canadian Rockies',2006,5,0.99,52,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (795,'SIEGE MADRE','A Boring Tale of a Frisbee And a Crocodile who must Vanquish a Moose in An Abandoned Mine Shaft',2006,7,0.99,111,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (796,'SIERRA DIVIDE','A Emotional Character Study of a Frisbee And a Mad Scientist who must Build a Madman in California',2006,3,0.99,135,12.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (797,'SILENCE KANE','A Emotional Drama of a Sumo Wrestler And a Dentist who must Confront a Sumo Wrestler in A Baloon',2006,7,0.99,67,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (798,'SILVERADO GOLDFINGER','A Stunning Epistle of a Sumo Wrestler And a Man who must Challenge a Waitress in Ancient India',2006,4,4.99,74,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (799,'SIMON NORTH','A Thrilling Documentary of a Technical Writer And a A Shark who must Face a Pioneer in A Shark Tank',2006,3,0.99,51,26.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (800,'SINNERS ATLANTIS','A Epic Display of a Dog And a Boat who must Succumb a Mad Scientist in An Abandoned Mine Shaft',2006,7,2.99,126,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (801,'SISTER FREDDY','A Stunning Saga of a Butler And a Woman who must Pursue a Explorer in Australia',2006,5,4.99,152,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (802,'SKY MIRACLE','A Epic Drama of a Mad Scientist And a Explorer who must Succumb a Waitress in An Abandoned Fun House',2006,7,2.99,132,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (803,'SLACKER LIAISONS','A Fast-Paced Tale of a A Shark And a Student who must Meet a Crocodile in Ancient China',2006,7,4.99,179,29.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (804,'SLEEPING SUSPECTS','A Stunning Reflection of a Sumo Wrestler And a Explorer who must Sink a Frisbee in A MySQL Convention',2006,7,4.99,129,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (805,'SLEEPLESS MONSOON','A Amazing Saga of a Moose And a Pastry Chef who must Escape a Butler in Australia',2006,5,4.99,64,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (806,'SLEEPY JAPANESE','A Emotional Epistle of a Moose And a Composer who must Fight a Technical Writer in The Outback',2006,4,2.99,137,25.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (807,'SLEUTH ORIENT','A Fateful Character Study of a Husband And a Dog who must Find a Feminist in Ancient India',2006,4,0.99,87,25.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (808,'SLING LUKE','A Intrepid Character Study of a Robot And a Monkey who must Reach a Secret Agent in An Abandoned Amusement Park',2006,5,0.99,84,10.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (809,'SLIPPER FIDELITY','A Taut Reflection of a Secret Agent And a Man who must Redeem a Explorer in A MySQL Convention',2006,5,0.99,156,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (810,'SLUMS DUCK','A Amazing Character Study of a Teacher And a Database Administrator who must Defeat a Waitress in A Jet Boat',2006,5,0.99,147,21.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (811,'SMILE EARRING','A Intrepid Drama of a Teacher And a Butler who must Build a Pastry Chef in Berlin',2006,4,2.99,60,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (812,'SMOKING BARBARELLA','A Lacklusture Saga of a Mad Cow And a Mad Scientist who must Sink a Cat in A MySQL Convention',2006,7,0.99,50,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (813,'SMOOCHY CONTROL','A Thrilling Documentary of a Husband And a Feminist who must Face a Mad Scientist in Ancient China',2006,7,0.99,184,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (814,'SNATCH SLIPPER','A Insightful Panorama of a Woman And a Feminist who must Defeat a Forensic Psychologist in Berlin',2006,6,4.99,110,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (815,'SNATCHERS MONTEZUMA','A Boring Epistle of a Sumo Wrestler And a Woman who must Escape a Man in The Canadian Rockies',2006,4,2.99,74,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (816,'SNOWMAN ROLLERCOASTER','A Fateful Display of a Lumberjack And a Girl who must Succumb a Mad Cow in A Manhattan Penthouse',2006,3,0.99,62,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (817,'SOLDIERS EVOLUTION','A Lacklusture Panorama of a A Shark And a Pioneer who must Confront a Student in The First Manned Space Station',2006,7,4.99,185,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (818,'SOMETHING DUCK','A Boring Character Study of a Car And a Husband who must Outgun a Frisbee in The First Manned Space Station',2006,4,4.99,180,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (819,'SONG HEDWIG','A Amazing Documentary of a Man And a Husband who must Confront a Squirrel in A MySQL Convention',2006,3,0.99,165,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (820,'SONS INTERVIEW','A Taut Character Study of a Explorer And a Mad Cow who must Battle a Hunter in Ancient China',2006,3,2.99,184,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (821,'SORORITY QUEEN','A Fast-Paced Display of a Squirrel And a Composer who must Fight a Forensic Psychologist in A Jet Boat',2006,6,0.99,184,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (822,'SOUP WISDOM','A Fast-Paced Display of a Robot And a Butler who must Defeat a Butler in A MySQL Convention',2006,6,0.99,169,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (823,'SOUTH WAIT','A Amazing Documentary of a Car And a Robot who must Escape a Lumberjack in An Abandoned Amusement Park',2006,4,2.99,143,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (824,'SPARTACUS CHEAPER','A Thrilling Panorama of a Pastry Chef And a Secret Agent who must Overcome a Student in A Manhattan Penthouse',2006,4,4.99,52,19.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (825,'SPEAKEASY DATE','A Lacklusture Drama of a Forensic Psychologist And a Car who must Redeem a Man in A Manhattan Penthouse',2006,6,2.99,165,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (826,'SPEED SUIT','A Brilliant Display of a Frisbee And a Mad Scientist who must Succumb a Robot in Ancient China',2006,7,4.99,124,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (827,'SPICE SORORITY','A Fateful Display of a Pioneer And a Hunter who must Defeat a Husband in An Abandoned Mine Shaft',2006,5,4.99,141,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (828,'SPIKING ELEMENT','A Lacklusture Epistle of a Dentist And a Technical Writer who must Find a Dog in A Monastery',2006,7,2.99,79,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (829,'SPINAL ROCKY','A Lacklusture Epistle of a Sumo Wrestler And a Squirrel who must Defeat a Explorer in California',2006,7,2.99,138,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (830,'SPIRIT FLINTSTONES','A Brilliant Yarn of a Cat And a Car who must Confront a Explorer in Ancient Japan',2006,7,0.99,149,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (831,'SPIRITED CASUALTIES','A Taut Story of a Waitress And a Man who must Face a Car in A Baloon Factory',2006,5,0.99,138,20.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (832,'SPLASH GUMP','A Taut Saga of a Crocodile And a Boat who must Conquer a Hunter in A Shark Tank',2006,5,0.99,175,16.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (833,'SPLENDOR PATTON','A Taut Story of a Dog And a Explorer who must Find a Astronaut in Berlin',2006,5,0.99,134,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (834,'SPOILERS HELLFIGHTERS','A Fanciful Story of a Technical Writer And a Squirrel who must Defeat a Dog in The Gulf of Mexico',2006,4,0.99,151,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (835,'SPY MILE','A Thrilling Documentary of a Feminist And a Feminist who must Confront a Feminist in A Baloon',2006,6,2.99,112,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (836,'SQUAD FISH','A Fast-Paced Display of a Pastry Chef And a Dog who must Kill a Teacher in Berlin',2006,3,2.99,136,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (837,'STAGE WORLD','A Lacklusture Panorama of a Woman And a Frisbee who must Chase a Crocodile in A Jet Boat',2006,4,2.99,85,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (838,'STAGECOACH ARMAGEDDON','A Touching Display of a Pioneer And a Butler who must Chase a Car in California',2006,5,4.99,112,25.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (839,'STALLION SUNDANCE','A Fast-Paced Tale of a Car And a Dog who must Outgun a A Shark in Australia',2006,5,0.99,130,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (840,'STAMPEDE DISTURBING','A Unbelieveable Tale of a Woman And a Lumberjack who must Fight a Frisbee in A U-Boat',2006,5,0.99,75,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (841,'STAR OPERATION','A Insightful Character Study of a Girl And a Car who must Pursue a Mad Cow in A Shark Tank',2006,5,2.99,181,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (842,'STATE WASTELAND','A Beautiful Display of a Cat And a Pastry Chef who must Outrace a Mad Cow in A Jet Boat',2006,4,2.99,113,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (843,'STEEL SANTA','A Fast-Paced Yarn of a Composer And a Frisbee who must Face a Moose in Nigeria',2006,4,4.99,143,15.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (844,'STEERS ARMAGEDDON','A Stunning Character Study of a Car And a Girl who must Succumb a Car in A MySQL Convention',2006,6,4.99,140,16.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (845,'STEPMOM DREAM','A Touching Epistle of a Crocodile And a Teacher who must Build a Forensic Psychologist in A MySQL Convention',2006,7,4.99,48,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (846,'STING PERSONAL','A Fanciful Drama of a Frisbee And a Dog who must Fight a Madman in A Jet Boat',2006,3,4.99,93,9.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (847,'STOCK GLASS','A Boring Epistle of a Crocodile And a Lumberjack who must Outgun a Moose in Ancient China',2006,7,2.99,160,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (848,'STONE FIRE','A Intrepid Drama of a Astronaut And a Crocodile who must Find a Boat in Soviet Georgia',2006,3,0.99,94,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (849,'STORM HAPPINESS','A Insightful Drama of a Feminist And a A Shark who must Vanquish a Boat in A Shark Tank',2006,6,0.99,57,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (850,'STORY SIDE','A Lacklusture Saga of a Boy And a Cat who must Sink a Dentist in An Abandoned Mine Shaft',2006,7,0.99,163,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (851,'STRAIGHT HOURS','A Boring Panorama of a Secret Agent And a Girl who must Sink a Waitress in The Outback',2006,3,0.99,151,19.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (852,'STRANGELOVE DESIRE','A Awe-Inspiring Panorama of a Lumberjack And a Waitress who must Defeat a Crocodile in An Abandoned Amusement Park',2006,4,0.99,103,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (853,'STRANGER STRANGERS','A Awe-Inspiring Yarn of a Womanizer And a Explorer who must Fight a Woman in The First Manned Space Station',2006,3,4.99,139,12.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (854,'STRANGERS GRAFFITI','A Brilliant Character Study of a Secret Agent And a Man who must Find a Cat in The Gulf of Mexico',2006,4,4.99,119,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (855,'STREAK RIDGEMONT','A Astounding Character Study of a Hunter And a Waitress who must Sink a Man in New Orleans',2006,7,0.99,132,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (856,'STREETCAR INTENTIONS','A Insightful Character Study of a Waitress And a Crocodile who must Sink a Waitress in The Gulf of Mexico',2006,5,4.99,73,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (857,'STRICTLY SCARFACE','A Touching Reflection of a Crocodile And a Dog who must Chase a Hunter in An Abandoned Fun House',2006,3,2.99,144,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (858,'SUBMARINE BED','A Amazing Display of a Car And a Monkey who must Fight a Teacher in Soviet Georgia',2006,5,4.99,127,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (859,'SUGAR WONKA','A Touching Story of a Dentist And a Database Administrator who must Conquer a Astronaut in An Abandoned Amusement Park',2006,3,4.99,114,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (860,'SUICIDES SILENCE','A Emotional Character Study of a Car And a Girl who must Face a Composer in A U-Boat',2006,4,4.99,93,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (861,'SUIT WALLS','A Touching Panorama of a Lumberjack And a Frisbee who must Build a Dog in Australia',2006,3,4.99,111,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (862,'SUMMER SCARFACE','A Emotional Panorama of a Lumberjack And a Hunter who must Meet a Girl in A Shark Tank',2006,5,0.99,53,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (863,'SUN CONFESSIONS','A Beautiful Display of a Mad Cow And a Dog who must Redeem a Waitress in An Abandoned Amusement Park',2006,5,0.99,141,9.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (864,'SUNDANCE INVASION','A Epic Drama of a Lumberjack And a Explorer who must Confront a Hunter in A Baloon Factory',2006,5,0.99,92,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (865,'SUNRISE LEAGUE','A Beautiful Epistle of a Madman And a Butler who must Face a Crocodile in A Manhattan Penthouse',2006,3,4.99,135,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (866,'SUNSET RACER','A Awe-Inspiring Reflection of a Astronaut And a A Shark who must Defeat a Forensic Psychologist in California',2006,6,0.99,48,28.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (867,'SUPER WYOMING','A Action-Packed Saga of a Pastry Chef And a Explorer who must Discover a A Shark in The Outback',2006,5,4.99,58,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (868,'SUPERFLY TRIP','A Beautiful Saga of a Lumberjack And a Teacher who must Build a Technical Writer in An Abandoned Fun House',2006,5,0.99,114,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (869,'SUSPECTS QUILLS','A Emotional Epistle of a Pioneer And a Crocodile who must Battle a Man in A Manhattan Penthouse',2006,4,2.99,47,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (870,'SWARM GOLD','A Insightful Panorama of a Crocodile And a Boat who must Conquer a Sumo Wrestler in A MySQL Convention',2006,4,0.99,123,12.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (871,'SWEDEN SHINING','A Taut Documentary of a Car And a Robot who must Conquer a Boy in The Canadian Rockies',2006,6,4.99,176,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (872,'SWEET BROTHERHOOD','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Chase a Forensic Psychologist in A Baloon',2006,3,2.99,185,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (873,'SWEETHEARTS SUSPECTS','A Brilliant Character Study of a Frisbee And a Sumo Wrestler who must Confront a Woman in The Gulf of Mexico',2006,3,0.99,108,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (874,'TADPOLE PARK','A Beautiful Tale of a Frisbee And a Moose who must Vanquish a Dog in An Abandoned Amusement Park',2006,6,2.99,155,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (875,'TALENTED HOMICIDE','A Lacklusture Panorama of a Dentist And a Forensic Psychologist who must Outrace a Pioneer in A U-Boat',2006,6,0.99,173,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (876,'TARZAN VIDEOTAPE','A Fast-Paced Display of a Lumberjack And a Mad Scientist who must Succumb a Sumo Wrestler in The Sahara Desert',2006,3,2.99,91,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (877,'TAXI KICK','A Amazing Epistle of a Girl And a Woman who must Outrace a Waitress in Soviet Georgia',2006,4,0.99,64,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (878,'TEEN APOLLO','A Awe-Inspiring Drama of a Dog And a Man who must Escape a Robot in A Shark Tank',2006,3,4.99,74,25.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (879,'TELEGRAPH VOYAGE','A Fateful Yarn of a Husband And a Dog who must Battle a Waitress in A Jet Boat',2006,3,4.99,148,20.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (880,'TELEMARK HEARTBREAKERS','A Action-Packed Panorama of a Technical Writer And a Man who must Build a Forensic Psychologist in A Manhattan Penthouse',2006,6,2.99,152,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (881,'TEMPLE ATTRACTION','A Action-Packed Saga of a Forensic Psychologist And a Woman who must Battle a Womanizer in Soviet Georgia',2006,5,4.99,71,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (882,'TENENBAUMS COMMAND','A Taut Display of a Pioneer And a Man who must Reach a Girl in The Gulf of Mexico',2006,4,0.99,99,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (883,'TEQUILA PAST','A Action-Packed Panorama of a Mad Scientist And a Robot who must Challenge a Student in Nigeria',2006,6,4.99,53,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (884,'TERMINATOR CLUB','A Touching Story of a Crocodile And a Girl who must Sink a Man in The Gulf of Mexico',2006,5,4.99,88,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (885,'TEXAS WATCH','A Awe-Inspiring Yarn of a Student And a Teacher who must Fight a Teacher in An Abandoned Amusement Park',2006,7,0.99,179,22.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (886,'THEORY MERMAID','A Fateful Yarn of a Composer And a Monkey who must Vanquish a Womanizer in The First Manned Space Station',2006,5,0.99,184,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (887,'THIEF PELICAN','A Touching Documentary of a Madman And a Mad Scientist who must Outrace a Feminist in An Abandoned Mine Shaft',2006,5,4.99,135,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (888,'THIN SAGEBRUSH','A Emotional Drama of a Husband And a Lumberjack who must Build a Cat in Ancient India',2006,5,4.99,53,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (889,'TIES HUNGER','A Insightful Saga of a Astronaut And a Explorer who must Pursue a Mad Scientist in A U-Boat',2006,3,4.99,111,28.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (890,'TIGHTS DAWN','A Thrilling Epistle of a Boat And a Secret Agent who must Face a Boy in A Baloon',2006,5,0.99,172,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (891,'TIMBERLAND SKY','A Boring Display of a Man And a Dog who must Redeem a Girl in A U-Boat',2006,3,0.99,69,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (892,'TITANIC BOONDOCK','A Brilliant Reflection of a Feminist And a Dog who must Fight a Boy in A Baloon Factory',2006,3,4.99,104,18.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (893,'TITANS JERK','A Unbelieveable Panorama of a Feminist And a Sumo Wrestler who must Challenge a Technical Writer in Ancient China',2006,4,4.99,91,11.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (894,'TOMATOES HELLFIGHTERS','A Thoughtful Epistle of a Madman And a Astronaut who must Overcome a Monkey in A Shark Tank',2006,6,0.99,68,23.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (895,'TOMORROW HUSTLER','A Thoughtful Story of a Moose And a Husband who must Face a Secret Agent in The Sahara Desert',2006,3,2.99,142,21.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (896,'TOOTSIE PILOT','A Awe-Inspiring Documentary of a Womanizer And a Pastry Chef who must Kill a Lumberjack in Berlin',2006,3,0.99,157,10.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (897,'TORQUE BOUND','A Emotional Display of a Crocodile And a Husband who must Reach a Man in Ancient Japan',2006,3,4.99,179,27.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (898,'TOURIST PELICAN','A Boring Story of a Butler And a Astronaut who must Outrace a Pioneer in Australia',2006,4,4.99,152,18.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (899,'TOWERS HURRICANE','A Fateful Display of a Monkey And a Car who must Sink a Husband in A MySQL Convention',2006,7,0.99,144,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (900,'TOWN ARK','A Awe-Inspiring Documentary of a Moose And a Madman who must Meet a Dog in An Abandoned Mine Shaft',2006,6,2.99,136,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (901,'TRACY CIDER','A Touching Reflection of a Database Administrator And a Madman who must Build a Lumberjack in Nigeria',2006,3,0.99,142,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (902,'TRADING PINOCCHIO','A Emotional Character Study of a Student And a Explorer who must Discover a Frisbee in The First Manned Space Station',2006,6,4.99,170,22.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (903,'TRAFFIC HOBBIT','A Amazing Epistle of a Squirrel And a Lumberjack who must Succumb a Database Administrator in A U-Boat',2006,5,4.99,139,13.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (904,'TRAIN BUNCH','A Thrilling Character Study of a Robot And a Squirrel who must Face a Dog in Ancient India',2006,3,4.99,71,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (905,'TRAINSPOTTING STRANGERS','A Fast-Paced Drama of a Pioneer And a Mad Cow who must Challenge a Madman in Ancient Japan',2006,7,4.99,132,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (906,'TRAMP OTHERS','A Brilliant Display of a Composer And a Cat who must Succumb a A Shark in Ancient India',2006,4,0.99,171,27.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (907,'TRANSLATION SUMMER','A Touching Reflection of a Man And a Monkey who must Pursue a Womanizer in A MySQL Convention',2006,4,0.99,168,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (908,'TRAP GUYS','A Unbelieveable Story of a Boy And a Mad Cow who must Challenge a Database Administrator in The Sahara Desert',2006,3,4.99,110,11.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (909,'TREASURE COMMAND','A Emotional Saga of a Car And a Madman who must Discover a Pioneer in California',2006,3,0.99,102,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (910,'TREATMENT JEKYLL','A Boring Story of a Teacher And a Student who must Outgun a Cat in An Abandoned Mine Shaft',2006,3,0.99,87,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (911,'TRIP NEWTON','A Fanciful Character Study of a Lumberjack And a Car who must Discover a Cat in An Abandoned Amusement Park',2006,7,4.99,64,14.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (912,'TROJAN TOMORROW','A Astounding Panorama of a Husband And a Sumo Wrestler who must Pursue a Boat in Ancient India',2006,3,2.99,52,9.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (913,'TROOPERS METAL','A Fanciful Drama of a Monkey And a Feminist who must Sink a Man in Berlin',2006,3,0.99,115,20.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (914,'TROUBLE DATE','A Lacklusture Panorama of a Forensic Psychologist And a Woman who must Kill a Explorer in Ancient Japan',2006,6,2.99,61,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (915,'TRUMAN CRAZY','A Thrilling Epistle of a Moose And a Boy who must Meet a Database Administrator in A Monastery',2006,7,4.99,92,9.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (916,'TURN STAR','A Stunning Tale of a Man And a Monkey who must Chase a Student in New Orleans',2006,3,2.99,80,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (917,'TUXEDO MILE','A Boring Drama of a Man And a Forensic Psychologist who must Face a Frisbee in Ancient India',2006,3,2.99,152,24.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (918,'TWISTED PIRATES','A Touching Display of a Frisbee And a Boat who must Kill a Girl in A MySQL Convention',2006,4,4.99,152,23.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (919,'TYCOON GATHERING','A Emotional Display of a Husband And a A Shark who must Succumb a Madman in A Manhattan Penthouse',2006,3,4.99,82,17.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (920,'UNBREAKABLE KARATE','A Amazing Character Study of a Robot And a Student who must Chase a Robot in Australia',2006,3,0.99,62,16.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (921,'UNCUT SUICIDES','A Intrepid Yarn of a Explorer And a Pastry Chef who must Pursue a Mad Cow in A U-Boat',2006,7,2.99,172,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (922,'UNDEFEATED DALMATIONS','A Unbelieveable Display of a Crocodile And a Feminist who must Overcome a Moose in An Abandoned Amusement Park',2006,7,4.99,107,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (923,'UNFAITHFUL KILL','A Taut Documentary of a Waitress And a Mad Scientist who must Battle a Technical Writer in New Orleans',2006,7,2.99,78,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (924,'UNFORGIVEN ZOOLANDER','A Taut Epistle of a Monkey And a Sumo Wrestler who must Vanquish a A Shark in A Baloon Factory',2006,7,0.99,129,15.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (925,'UNITED PILOT','A Fast-Paced Reflection of a Cat And a Mad Cow who must Fight a Car in The Sahara Desert',2006,3,0.99,164,27.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (926,'UNTOUCHABLES SUNRISE','A Amazing Documentary of a Woman And a Astronaut who must Outrace a Teacher in An Abandoned Fun House',2006,5,2.99,120,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (927,'UPRISING UPTOWN','A Fanciful Reflection of a Boy And a Butler who must Pursue a Woman in Berlin',2006,6,2.99,174,16.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (928,'UPTOWN YOUNG','A Fateful Documentary of a Dog And a Hunter who must Pursue a Teacher in An Abandoned Amusement Park',2006,5,2.99,84,16.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (929,'USUAL UNTOUCHABLES','A Touching Display of a Explorer And a Lumberjack who must Fight a Forensic Psychologist in A Shark Tank',2006,5,4.99,128,21.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (930,'VACATION BOONDOCK','A Fanciful Character Study of a Secret Agent And a Mad Scientist who must Reach a Teacher in Australia',2006,4,2.99,145,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (931,'VALENTINE VANISHING','A Thrilling Display of a Husband And a Butler who must Reach a Pastry Chef in California',2006,7,0.99,48,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (932,'VALLEY PACKER','A Astounding Documentary of a Astronaut And a Boy who must Outrace a Sumo Wrestler in Berlin',2006,3,0.99,73,21.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (933,'VAMPIRE WHALE','A Epic Story of a Lumberjack And a Monkey who must Confront a Pioneer in A MySQL Convention',2006,4,4.99,126,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (934,'VANILLA DAY','A Fast-Paced Saga of a Girl And a Forensic Psychologist who must Redeem a Girl in Nigeria',2006,7,4.99,122,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (935,'VANISHED GARDEN','A Intrepid Character Study of a Squirrel And a A Shark who must Kill a Lumberjack in California',2006,5,0.99,142,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (936,'VANISHING ROCKY','A Brilliant Reflection of a Man And a Woman who must Conquer a Pioneer in A MySQL Convention',2006,3,2.99,123,21.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (937,'VARSITY TRIP','A Action-Packed Character Study of a Astronaut And a Explorer who must Reach a Monkey in A MySQL Convention',2006,7,2.99,85,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (938,'VELVET TERMINATOR','A Lacklusture Tale of a Pastry Chef And a Technical Writer who must Confront a Crocodile in An Abandoned Amusement Park',2006,3,4.99,173,14.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (939,'VERTIGO NORTHWEST','A Unbelieveable Display of a Mad Scientist And a Mad Scientist who must Outgun a Mad Cow in Ancient Japan',2006,4,2.99,90,17.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (940,'VICTORY ACADEMY','A Insightful Epistle of a Mad Scientist And a Explorer who must Challenge a Cat in The Sahara Desert',2006,6,0.99,64,19.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (941,'VIDEOTAPE ARSENIC','A Lacklusture Display of a Girl And a Astronaut who must Succumb a Student in Australia',2006,4,4.99,145,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (942,'VIETNAM SMOOCHY','A Lacklusture Display of a Butler And a Man who must Sink a Explorer in Soviet Georgia',2006,7,0.99,174,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (943,'VILLAIN DESPERATE','A Boring Yarn of a Pioneer And a Feminist who must Redeem a Cat in An Abandoned Amusement Park',2006,4,4.99,76,27.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (944,'VIRGIN DAISY','A Awe-Inspiring Documentary of a Robot And a Mad Scientist who must Reach a Database Administrator in A Shark Tank',2006,6,4.99,179,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (945,'VIRGINIAN PLUTO','A Emotional Panorama of a Dentist And a Crocodile who must Meet a Boy in Berlin',2006,5,0.99,164,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (946,'VIRTUAL SPOILERS','A Fateful Tale of a Database Administrator And a Squirrel who must Discover a Student in Soviet Georgia',2006,3,4.99,144,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (947,'VISION TORQUE','A Thoughtful Documentary of a Dog And a Man who must Sink a Man in A Shark Tank',2006,5,0.99,59,16.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (948,'VOICE PEACH','A Amazing Panorama of a Pioneer And a Student who must Overcome a Mad Scientist in A Manhattan Penthouse',2006,6,0.99,139,22.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (949,'VOLCANO TEXAS','A Awe-Inspiring Yarn of a Hunter And a Feminist who must Challenge a Dentist in The Outback',2006,6,0.99,157,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (950,'VOLUME HOUSE','A Boring Tale of a Dog And a Woman who must Meet a Dentist in California',2006,7,4.99,132,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (951,'VOYAGE LEGALLY','A Epic Tale of a Squirrel And a Hunter who must Conquer a Boy in An Abandoned Mine Shaft',2006,6,0.99,78,28.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (952,'WAGON JAWS','A Intrepid Drama of a Moose And a Boat who must Kill a Explorer in A Manhattan Penthouse',2006,7,2.99,152,17.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (953,'WAIT CIDER','A Intrepid Epistle of a Woman And a Forensic Psychologist who must Succumb a Astronaut in A Manhattan Penthouse',2006,3,0.99,112,9.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (954,'WAKE JAWS','A Beautiful Saga of a Feminist And a Composer who must Challenge a Moose in Berlin',2006,7,4.99,73,18.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (955,'WALLS ARTIST','A Insightful Panorama of a Teacher And a Teacher who must Overcome a Mad Cow in An Abandoned Fun House',2006,7,4.99,135,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (956,'WANDA CHAMBER','A Insightful Drama of a A Shark And a Pioneer who must Find a Womanizer in The Outback',2006,7,4.99,107,23.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (957,'WAR NOTTING','A Boring Drama of a Teacher And a Sumo Wrestler who must Challenge a Secret Agent in The Canadian Rockies',2006,7,4.99,80,26.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (958,'WARDROBE PHANTOM','A Action-Packed Display of a Mad Cow And a Astronaut who must Kill a Car in Ancient India',2006,6,2.99,178,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (959,'WARLOCK WEREWOLF','A Astounding Yarn of a Pioneer And a Crocodile who must Defeat a A Shark in The Outback',2006,6,2.99,83,10.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (960,'WARS PLUTO','A Taut Reflection of a Teacher And a Database Administrator who must Chase a Madman in The Sahara Desert',2006,5,2.99,128,15.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (961,'WASH HEAVENLY','A Awe-Inspiring Reflection of a Cat And a Pioneer who must Escape a Hunter in Ancient China',2006,7,4.99,161,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (962,'WASTELAND DIVINE','A Fanciful Story of a Database Administrator And a Womanizer who must Fight a Database Administrator in Ancient China',2006,7,2.99,85,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (963,'WATCH TRACY','A Fast-Paced Yarn of a Dog And a Frisbee who must Conquer a Hunter in Nigeria',2006,5,0.99,78,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (964,'WATERFRONT DELIVERANCE','A Unbelieveable Documentary of a Dentist And a Technical Writer who must Build a Womanizer in Nigeria',2006,4,4.99,61,17.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (965,'WATERSHIP FRONTIER','A Emotional Yarn of a Boat And a Crocodile who must Meet a Moose in Soviet Georgia',2006,6,0.99,112,28.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (966,'WEDDING APOLLO','A Action-Packed Tale of a Student And a Waitress who must Conquer a Lumberjack in An Abandoned Mine Shaft',2006,3,0.99,70,14.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (967,'WEEKEND PERSONAL','A Fast-Paced Documentary of a Car And a Butler who must Find a Frisbee in A Jet Boat',2006,5,2.99,134,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (968,'WEREWOLF LOLA','A Fanciful Story of a Man And a Sumo Wrestler who must Outrace a Student in A Monastery',2006,6,4.99,79,19.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (969,'WEST LION','A Intrepid Drama of a Butler And a Lumberjack who must Challenge a Database Administrator in A Manhattan Penthouse',2006,4,4.99,159,29.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (970,'WESTWARD SEABISCUIT','A Lacklusture Tale of a Butler And a Husband who must Face a Boy in Ancient China',2006,7,0.99,52,11.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (971,'WHALE BIKINI','A Intrepid Story of a Pastry Chef And a Database Administrator who must Kill a Feminist in A MySQL Convention',2006,4,4.99,109,11.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (972,'WHISPERER GIANT','A Intrepid Story of a Dentist And a Hunter who must Confront a Monkey in Ancient Japan',2006,4,4.99,59,24.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (973,'WIFE TURN','A Awe-Inspiring Epistle of a Teacher And a Feminist who must Confront a Pioneer in Ancient Japan',2006,3,4.99,183,27.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (974,'WILD APOLLO','A Beautiful Story of a Monkey And a Sumo Wrestler who must Conquer a A Shark in A MySQL Convention',2006,4,0.99,181,24.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (975,'WILLOW TRACY','A Brilliant Panorama of a Boat And a Astronaut who must Challenge a Teacher in A Manhattan Penthouse',2006,6,2.99,137,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (976,'WIND PHANTOM','A Touching Saga of a Madman And a Forensic Psychologist who must Build a Sumo Wrestler in An Abandoned Mine Shaft',2006,6,0.99,111,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (977,'WINDOW SIDE','A Astounding Character Study of a Womanizer And a Hunter who must Escape a Robot in A Monastery',2006,3,2.99,85,25.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (978,'WISDOM WORKER','A Unbelieveable Saga of a Forensic Psychologist And a Student who must Face a Squirrel in The First Manned Space Station',2006,3,0.99,98,12.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (979,'WITCHES PANIC','A Awe-Inspiring Drama of a Secret Agent And a Hunter who must Fight a Moose in Nigeria',2006,6,4.99,100,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (980,'WIZARD COLDBLOODED','A Lacklusture Display of a Robot And a Girl who must Defeat a Sumo Wrestler in A MySQL Convention',2006,4,4.99,75,12.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (981,'WOLVES DESIRE','A Fast-Paced Drama of a Squirrel And a Robot who must Succumb a Technical Writer in A Manhattan Penthouse',2006,7,0.99,55,13.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (982,'WOMEN DORADO','A Insightful Documentary of a Waitress And a Butler who must Vanquish a Composer in Australia',2006,4,0.99,126,23.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (983,'WON DARES','A Unbelieveable Documentary of a Teacher And a Monkey who must Defeat a Explorer in A U-Boat',2006,7,2.99,105,18.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (984,'WONDERFUL DROP','A Boring Panorama of a Woman And a Madman who must Overcome a Butler in A U-Boat',2006,3,2.99,126,20.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (985,'WONDERLAND CHRISTMAS','A Awe-Inspiring Character Study of a Waitress And a Car who must Pursue a Mad Scientist in The First Manned Space Station',2006,4,4.99,111,19.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (986,'WONKA SEA','A Brilliant Saga of a Boat And a Mad Scientist who must Meet a Moose in Ancient India',2006,6,2.99,85,24.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (987,'WORDS HUNTER','A Action-Packed Reflection of a Composer And a Mad Scientist who must Face a Pioneer in A MySQL Convention',2006,3,2.99,116,13.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (988,'WORKER TARZAN','A Action-Packed Yarn of a Secret Agent And a Technical Writer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,7,2.99,139,26.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (989,'WORKING MICROCOSMOS','A Stunning Epistle of a Dentist And a Dog who must Kill a Madman in Ancient China',2006,4,4.99,74,22.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (990,'WORLD LEATHERNECKS','A Unbelieveable Tale of a Pioneer And a Astronaut who must Overcome a Robot in An Abandoned Amusement Park',2006,3,0.99,171,13.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (991,'WORST BANGER','A Thrilling Drama of a Madman And a Dentist who must Conquer a Boy in The Outback',2006,4,2.99,185,26.99,'PG','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (992,'WRATH MILE','A Intrepid Reflection of a Technical Writer And a Hunter who must Defeat a Sumo Wrestler in A Monastery',2006,5,0.99,176,17.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (993,'WRONG BEHAVIOR','A Emotional Saga of a Crocodile And a Sumo Wrestler who must Discover a Mad Cow in New Orleans',2006,6,2.99,178,10.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (994,'WYOMING STORM','A Awe-Inspiring Panorama of a Robot And a Boat who must Overcome a Feminist in A U-Boat',2006,6,4.99,100,29.99,'PG-13','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (995,'YENTL IDAHO','A Amazing Display of a Robot And a Astronaut who must Fight a Womanizer in Berlin',2006,5,4.99,86,11.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (996,'YOUNG LANGUAGE','A Unbelieveable Yarn of a Boat And a Database Administrator who must Meet a Boy in The First Manned Space Station',2006,6,0.99,183,9.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (997,'YOUTH KICK','A Touching Drama of a Teacher And a Cat who must Challenge a Technical Writer in A U-Boat',2006,4,0.99,179,14.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (998,'ZHIVAGO CORE','A Fateful Yarn of a Composer And a Man who must Face a Boy in The Canadian Rockies',2006,6,0.99,105,10.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (999,'ZOOLANDER FICTION','A Fateful Reflection of a Waitress And a Boat who must Discover a Sumo Wrestler in Ancient China',2006,5,2.99,101,28.99,'R','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (1000,'ZORRO ARK','A Intrepid Panorama of a Mad Scientist And a Boy who must Redeem a Boy in A Monastery',2006,3,4.99,50,18.99,'NC-17','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (1001,'MANU FILM','A beautiful film',2006,6,0.99,86,20.99,'G','2006-02-15 05:03:42');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (1013,'MANU FILM','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies',2006,6,0.99,86,20.99,'G','2017-04-14 10:34:20');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (1014,'MANU FILM','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies',2006,6,0.99,86,20.99,'G','2017-04-14 11:05:06');
insert into   film  (  film_id  ,  title  ,  description  ,  release_year  ,  rental_duration  ,  rental_rate  ,  length  ,  replacement_cost  ,  rating  ,  last_update  ) values (1015,'MANU FILM','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies',2006,6,0.99,86,20.99,'G','2017-04-14 11:05:13');
